/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.models;

import lombok.NonNull;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.viewer.wicket.model.models.ScalarModel;
import org.apache.wicket.model.ChainingModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class BooleanModel
extends ChainingModel<Boolean> {
    private static final long serialVersionUID = 1L;
    final boolean isPrimitive;

    public static BooleanModel forScalarModel(@NonNull ScalarModel scalarModel) {
        if (scalarModel == null) {
            throw new NullPointerException("scalarModel is marked non-null but is null");
        }
        return new BooleanModel(scalarModel);
    }

    protected BooleanModel(ScalarModel scalarModel) {
        super((Object)scalarModel);
        ObjectSpecification spec = this.scalarModel().getElementType();
        this.isPrimitive = spec.getFullIdentifier().equals("boolean");
    }

    public Boolean getObject() {
        ManagedObject adapter = this.scalarModel().getObject();
        Boolean value = adapter != null ? (Boolean)adapter.getPojo() : null;
        return this.isPrimitive && value == null ? Boolean.FALSE : value;
    }

    public void setObject(Boolean value) {
        ManagedObject adaptedValue = ManagedObject.value((ObjectSpecification)this.scalarModel().getElementType(), (Object)(value == null && this.isPrimitive ? Boolean.FALSE : value));
        this.scalarModel().setObject(adaptedValue);
    }

    public IModel<String> asStringModel(final String notSetLiteral, final String trueLiteral, final String falseLiteral) {
        return new Model<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                Boolean bool = BooleanModel.this.getObject();
                return bool == null ? notSetLiteral : (bool != false ? trueLiteral : falseLiteral);
            }
        };
    }

    protected ScalarModel scalarModel() {
        return (ScalarModel)super.getTarget();
    }
}

