/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.itemreuse;

import java.util.Iterator;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.causeway.viewer.wicket.model.models.coll.DataRowWkt;
import org.apache.wicket.markup.repeater.IItemFactory;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;

public class ReuseIfRowIndexEqualsStrategy
implements IItemReuseStrategy {
    private static final long serialVersionUID = 1L;
    private static ReuseIfRowIndexEqualsStrategy INSTANCE = new ReuseIfRowIndexEqualsStrategy();

    public static ReuseIfRowIndexEqualsStrategy getInstance() {
        return INSTANCE;
    }

    public <T> Iterator<Item<T>> getItems(final IItemFactory<T> factory, final Iterator<IModel<T>> newModels, Iterator<Item<T>> existingItems) {
        final ItemByRowIndexMap itemByRowIndex = new ItemByRowIndexMap();
        existingItems.forEachRemaining(itemByRowIndex::putItem);
        return new Iterator<Item<T>>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return newModels.hasNext();
            }

            @Override
            public Item<T> next() {
                IModel model = (IModel)newModels.next();
                Item item = itemByRowIndex.getItem(model).map(oldItem -> ReuseIfRowIndexEqualsStrategy.withIndex(this.index, oldItem)).orElseGet(() -> factory.newItem(this.index, model));
                ++this.index;
                return item;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static <T> Item<T> withIndex(int index, Item<T> item) {
        item.setIndex(index);
        return item;
    }

    private static class ItemByRowIndexMap<T>
    extends TreeMap<Integer, Item<T>> {
        private static final long serialVersionUID = 1L;

        private ItemByRowIndexMap() {
        }

        void putItem(Item<T> item) {
            int rowIndex = ItemByRowIndexMap.rowIndex(item.getModel());
            if (rowIndex > -1) {
                super.put(rowIndex, item);
            }
        }

        Optional<Item<T>> getItem(IModel<T> model) {
            int rowIndex = ItemByRowIndexMap.rowIndex(model);
            return rowIndex > -1 ? Optional.ofNullable((Item)this.get(rowIndex)) : Optional.empty();
        }

        private static int rowIndex(IModel<?> model) {
            return model instanceof DataRowWkt ? ((DataRowWkt)model).getRowIndex() : -1;
        }
    }
}

