/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.models;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.applib.value.Blob;
import org.apache.causeway.applib.value.Clob;
import org.apache.causeway.viewer.wicket.model.models.ScalarConvertingModel;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.springframework.lang.Nullable;

public final class FileUploadModels {
    public static ScalarConvertingModel<List<FileUpload>, Blob> blob(@NonNull UiAttributeWkt attributeModel) {
        if (attributeModel == null) {
            throw new NullPointerException("attributeModel is marked non-null but is null");
        }
        return new ScalarConvertingModel<List<FileUpload>, Blob>(attributeModel){
            private static final long serialVersionUID = 1L;

            @Override
            protected Blob toScalarValue(@Nullable List<FileUpload> fileUploads) {
                if (fileUploads == null || fileUploads.isEmpty()) {
                    return null;
                }
                FileUpload fileUpload = fileUploads.get(0);
                String contentType = fileUpload.getContentType();
                String clientFileName = fileUpload.getClientFileName();
                byte[] bytes = fileUpload.getBytes();
                Blob blob = new Blob(clientFileName, contentType, bytes);
                return blob;
            }

            @Override
            protected List<FileUpload> fromScalarValue(Blob blob) {
                return blob != null ? Collections.emptyList() : null;
            }
        };
    }

    public static ScalarConvertingModel<List<FileUpload>, Clob> clob(@NonNull UiAttributeWkt attributeModel, @NonNull Charset charset) {
        if (attributeModel == null) {
            throw new NullPointerException("attributeModel is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        final String charsetName = charset.name();
        return new ScalarConvertingModel<List<FileUpload>, Clob>(attributeModel){
            private static final long serialVersionUID = 1L;

            @Override
            protected Clob toScalarValue(@Nullable List<FileUpload> fileUploads) {
                if (fileUploads == null || fileUploads.isEmpty()) {
                    return null;
                }
                FileUpload fileUpload = fileUploads.get(0);
                String contentType = fileUpload.getContentType();
                String clientFileName = fileUpload.getClientFileName();
                String str = new String(fileUpload.getBytes(), charsetName);
                Clob clob = new Clob(clientFileName, contentType, (CharSequence)str);
                return clob;
            }

            @Override
            protected List<FileUpload> fromScalarValue(Clob clob) {
                return clob != null ? Collections.emptyList() : null;
            }
        };
    }

    @Generated
    private FileUploadModels() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

