/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.models.coll;

import java.util.Optional;
import lombok.Generated;
import org.apache.causeway.applib.Identifier;
import org.apache.causeway.applib.annotation.TableDecorator;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectMember;
import org.apache.causeway.core.metamodel.tabular.DataTableInteractive;
import org.apache.causeway.viewer.commons.model.hints.RenderingHint;
import org.apache.causeway.viewer.wicket.model.links.LinksProvider;
import org.apache.causeway.viewer.wicket.model.models.HasCommonContext;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModelEmpty;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModelParented;
import org.apache.wicket.model.IModel;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface CollectionModel
extends IModel<DataTableInteractive>,
HasCommonContext,
LinksProvider {
    public static CollectionModel empty() {
        return new CollectionModelEmpty();
    }

    public Identifier getIdentifier();

    public Variant getVariant();

    public DataTableInteractive getDataTableModel();

    public ObjectMember getMetaModel();

    default public ObjectSpecification getElementType() {
        return this.getMetaModel().getElementType();
    }

    public ManagedObject getParentObject();

    default public int getElementCount() {
        return this.getDataTableModel().getFilteredElementCount();
    }

    default public String getName() {
        return (String)this.getDataTableModel().titleObservable().getValue();
    }

    default public int getPageSize() {
        return this.getDataTableModel().getPageSize(this.getVariant().getPageSizeDefault());
    }

    default public Optional<TableDecorator> getTableDecoratorIfAny() {
        return this.getDataTableModel().getTableDecoratorIfAny();
    }

    default public boolean isHidden() {
        return "hidden".equals(this.getName());
    }

    public boolean isTableDataLoaded();

    default public Optional<Bookmark> parentedHintingBookmark() {
        Optional<Bookmark> optional;
        CollectionModel collectionModel = this;
        if (collectionModel instanceof CollectionModelParented) {
            CollectionModelParented parented = (CollectionModelParented)collectionModel;
            optional = Optional.ofNullable(parented.asHintingBookmark());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public static enum Variant {
        STANDALONE(RenderingHint.STANDALONE_PROPERTY_COLUMN, 25),
        PARENTED(RenderingHint.PARENTED_PROPERTY_COLUMN, 12);

        private final RenderingHint columnRenderingHint;
        private final int pageSizeDefault;

        public boolean isStandalone() {
            return this == STANDALONE;
        }

        public boolean isParented() {
            return this == PARENTED;
        }

        public RenderingHint getTitleColumnRenderingHint() {
            return this.isParented() ? RenderingHint.PARENTED_TITLE_COLUMN : RenderingHint.STANDALONE_TITLE_COLUMN;
        }

        @Generated
        private Variant(RenderingHint columnRenderingHint, int pageSizeDefault) {
            this.columnRenderingHint = columnRenderingHint;
            this.pageSizeDefault = pageSizeDefault;
        }

        @Generated
        public RenderingHint getColumnRenderingHint() {
            return this.columnRenderingHint;
        }

        @Generated
        public int getPageSizeDefault() {
            return this.pageSizeDefault;
        }
    }
}

