/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.value;

import java.util.Locale;
import lombok.NonNull;
import org.apache.causeway.applib.value.semantics.ValueSemanticsProvider;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.core.metamodel.commons.ViewOrEditMode;
import org.apache.causeway.core.metamodel.facets.object.value.ValueFacet;
import org.apache.causeway.core.metamodel.spec.feature.ObjectFeature;
import org.apache.causeway.viewer.wicket.model.value.ValueSemanticsModelAbstract;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class ConverterBasedOnValueSemantics<T>
extends ValueSemanticsModelAbstract
implements IConverter<T> {
    private static final long serialVersionUID = 1L;
    public final Class<T> type;
    public final Class<?> resolvedType;

    public ConverterBasedOnValueSemantics(@NonNull Class<T> type, @NonNull ObjectFeature propOrParam, @NonNull ViewOrEditMode scalarRepresentation) {
        super(propOrParam, scalarRepresentation);
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (propOrParam == null) {
            throw new NullPointerException("propOrParam is marked non-null but is null");
        }
        if (scalarRepresentation == null) {
            throw new NullPointerException("scalarRepresentation is marked non-null but is null");
        }
        this.type = type;
        this.resolvedType = ClassUtils.resolvePrimitiveIfNecessary((Class)propOrParam.getElementType().getCorrespondingClass());
        _Assert.assertTypeIsInstanceOf(this.resolvedType, type);
    }

    public final boolean canHandle(@Nullable Class<?> aType) {
        return aType != null && this.resolvedType.isAssignableFrom(ClassUtils.resolvePrimitiveIfNecessary(aType));
    }

    public final T convertToObject(String text, Locale locale) throws ConversionException {
        if (this.scalarRepresentation.isViewing()) {
            throw _Exceptions.illegalArgument((String)"Internal Error: cannot convert a rendering representation back to its value-type '%s' -> %s", (Object[])new Object[]{text, this.featureIdentifier});
        }
        ObjectFeature feature = this.feature();
        ValueFacet<T> valueFacet = this.valueFacet();
        ValueSemanticsProvider.Context context = valueFacet.createValueSemanticsContext(feature);
        try {
            return (T)valueFacet.selectParserForFeatureElseFallback(feature).parseTextRepresentation(context, text);
        }
        catch (Exception e) {
            if (e instanceof ConversionException) {
                throw e;
            }
            throw new ConversionException(e.getMessage(), (Throwable)e);
        }
    }

    public final String convertToString(T value, Locale locale) {
        ObjectFeature feature = this.feature();
        ValueFacet valueFacet = this.valueFacet();
        ValueSemanticsProvider.Context context = valueFacet.createValueSemanticsContext(feature);
        switch (this.scalarRepresentation) {
            case EDITING: {
                return valueFacet.selectParserForFeatureElseFallback(feature).parseableTextRepresentation(context, value);
            }
            case VIEWING: {
                return (String)this.propOrParam.fold(prop -> valueFacet.selectRendererForPropertyElseFallback(prop).titlePresentation(context, value), param -> valueFacet.selectRendererForParameterElseFallback(param).titlePresentation(context, value));
            }
        }
        throw _Exceptions.unmatchedCase((Object)this.scalarRepresentation);
    }

    public String getEditingPattern() {
        ObjectFeature feature = this.feature();
        ValueFacet<T> valueFacet = this.valueFacet();
        ValueSemanticsProvider.Context context = valueFacet.createValueSemanticsContext(feature);
        return valueFacet.selectParserForFeatureElseFallback(feature).getPattern(context);
    }

    protected ValueFacet<T> valueFacet() {
        return (ValueFacet)_Casts.uncheckedCast(super.valueFacet());
    }
}

