/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.models;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.causeway.applib.Identifier;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.BookmarkPolicy;
import org.apache.causeway.applib.annotation.PromptStyle;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.interactions.managed.ActionInteraction;
import org.apache.causeway.core.metamodel.interactions.managed.ParameterNegotiationModel;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.causeway.viewer.commons.model.action.HasManagedAction;
import org.apache.causeway.viewer.commons.model.action.UiActionForm;
import org.apache.causeway.viewer.wicket.model.models.BookmarkableModel;
import org.apache.causeway.viewer.wicket.model.models.FormExecutorContext;
import org.apache.causeway.viewer.wicket.model.models.InlinePromptContext;
import org.apache.causeway.viewer.wicket.model.models.ParameterModel;
import org.apache.causeway.viewer.wicket.model.models.PropertyModel;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModel;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModelParented;
import org.apache.causeway.viewer.wicket.model.models.interaction.act.ActionInteractionWkt;
import org.apache.causeway.viewer.wicket.model.models.interaction.act.UiParameterWkt;
import org.apache.causeway.viewer.wicket.model.util.PageParameterUtils;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public record ActionModel(UiObjectWkt parentEntityModel, ActionInteractionWkt delegate, ColumnActionModifier columnActionModifier) implements UiActionForm,
FormExecutorContext,
BookmarkableModel,
IModel<ManagedObject>
{
    ActionModel(UiObjectWkt parentEntityModel, ActionInteractionWkt delegate) {
        this(parentEntityModel, delegate, ColumnActionModifier.NONE);
    }

    public static ActionModel forEntity(UiObjectWkt parentEntityModel, Identifier actionIdentifier, Where where, ColumnActionModifier columnActionModifier, PropertyModel associatedWithPropertyIfAny, ParameterModel associatedWithParameterIfAny, CollectionModel associatedWithCollectionIfAny) {
        ActionInteractionWkt delegate = ActionInteractionWkt.forEntity(parentEntityModel, actionIdentifier, where, associatedWithPropertyIfAny, associatedWithParameterIfAny, associatedWithCollectionIfAny);
        return new ActionModel(parentEntityModel, delegate, columnActionModifier);
    }

    public static ActionModel forServiceAction(ObjectAction action, UiObjectWkt serviceModel) {
        return ActionModel.forEntity(serviceModel, action.getFeatureIdentifier(), Where.ANYWHERE, ColumnActionModifier.NONE, null, null, null);
    }

    public static ActionModel forEntity(ObjectAction action, UiObjectWkt parentEntityModel) {
        ActionModel.guardAgainstNotBookmarkable(parentEntityModel.getBookmarkedOwner());
        return ActionModel.forEntity(parentEntityModel, action.getFeatureIdentifier(), Where.OBJECT_FORMS, ColumnActionModifier.NONE, null, null, null);
    }

    public static ActionModel forEntityFromActionColumn(ObjectAction action, UiObjectWkt parentEntityModel, ColumnActionModifier columnActionModifier) {
        return ActionModel.forEntity(parentEntityModel, action.getFeatureIdentifier(), Where.OBJECT_FORMS, columnActionModifier, null, null, null);
    }

    public static ActionModel forCollection(ObjectAction action, CollectionModelParented collectionModel) {
        return ActionModel.forEntity(collectionModel.getObjectModel(), action.getFeatureIdentifier(), Where.OBJECT_FORMS, ColumnActionModifier.NONE, null, null, collectionModel);
    }

    public static ActionModel forPropertyOrParameter(ObjectAction action, UiAttributeWkt attributeModel) {
        return attributeModel instanceof PropertyModel ? ActionModel.forProperty(action, (PropertyModel)attributeModel) : ActionModel.forParameter(action, (ParameterModel)attributeModel);
    }

    public static ActionModel forProperty(ObjectAction action, PropertyModel propertyModel) {
        return ActionModel.forEntity(propertyModel.getParentUiModel(), action.getFeatureIdentifier(), Where.OBJECT_FORMS, ColumnActionModifier.NONE, propertyModel, null, null);
    }

    public static ActionModel forParameter(ObjectAction action, ParameterModel parameterModel) {
        ObjectActionParameter param = parameterModel.getMetaModel();
        if (param.isSingular() && param.getElementType().isCompositeValue()) {
            return ActionModel.forEntity(parameterModel.getParentUiModel(), action.getFeatureIdentifier(), Where.OBJECT_FORMS, ColumnActionModifier.NONE, null, parameterModel, null);
        }
        return null;
    }

    public ObjectAction getAction() {
        return this.delegate.getMetaModel();
    }

    public ActionInteraction getActionInteraction() {
        return this.delegate.actionInteraction();
    }

    @Override
    public PageParameters getPageParametersWithoutUiHints() {
        return PageParameterUtils.createPageParametersForAction(this.getParentObject(), this.getAction(), this.snapshotArgs());
    }

    @Override
    public PageParameters getPageParameters() {
        return this.getPageParametersWithoutUiHints();
    }

    @Override
    public BookmarkPolicy getBookmarkPolicy() {
        return BookmarkPolicy.AS_ROOT;
    }

    public UiObjectWkt getParentUiModel() {
        return this.parentEntityModel;
    }

    public Can<ManagedObject> snapshotArgs() {
        return this.delegate.parameterNegotiationModel().getParamValues();
    }

    public ManagedObject executeActionAndReturnResult() {
        ParameterNegotiationModel pendingArgs = this.delegate.parameterNegotiationModel();
        ManagedObject result = this.delegate.actionInteraction().invokeWithRuleChecking(pendingArgs);
        return result;
    }

    public void clearArguments() {
        this.delegate.resetParametersToDefault();
    }

    @Override
    public InlinePromptContext getInlinePromptContext() {
        return this.delegate.getInlinePromptContext();
    }

    public Stream<UiParameterWkt> streamPendingParamUiModels() {
        return this.delegate.streamParameterUiModels();
    }

    @Override
    public Optional<ParameterModel> getAssociatedParameter() {
        return this.delegate.associatedWithParameter();
    }

    public boolean isVisible() {
        return this.getVisibilityConsent().isAllowed();
    }

    public boolean isEnabled() {
        return this.getUsabilityConsent().isAllowed();
    }

    @Override
    public PromptStyle getPromptStyle() {
        PromptStyle promptStyle = this.getAction().getPromptStyle();
        return promptStyle;
    }

    public static Predicate<ActionModel> isPositionedAt(ActionLayout.Position panel) {
        return HasManagedAction.isPositionedAt((ActionLayout.Position)panel);
    }

    public void setObject(ManagedObject object) {
        throw new UnsupportedOperationException("ActionModel is a chained model - don't mess with the chain");
    }

    public void detach() {
        this.parentEntityModel.detach();
    }

    public ManagedObject getObject() {
        return (ManagedObject)this.parentEntityModel.getObject();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Model:classname=[");
        sb.append(this.getClass().getName()).append(']');
        sb.append(":nestedModel=[").append(this.parentEntityModel).append(']');
        return sb.toString();
    }

    private static void guardAgainstNotBookmarkable(ManagedObject objectAdapter) {
        boolean isIdentifiable = ManagedObjects.isIdentifiable((ManagedObject)objectAdapter);
        if (!isIdentifiable) {
            throw new IllegalArgumentException(String.format("Object '%s' is not identifiable (has no identifier).", objectAdapter.getTitle()));
        }
    }

    public static enum ColumnActionModifier {
        NONE,
        FORCE_STAY_ON_PAGE,
        FORCE_NEW_BROWSER_WINDOW;


        public boolean isNone() {
            return this == NONE;
        }

        public boolean isForceStayOnPage() {
            return this == FORCE_STAY_ON_PAGE;
        }

        public boolean isForceNewBrowserWindow() {
            return this == FORCE_NEW_BROWSER_WINDOW;
        }
    }
}

