/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.models;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.LongAdder;
import lombok.Generated;
import org.apache.causeway.applib.fa.FontAwesomeLayers;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.commons.functional.Either;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.commons.internal.functions._Functions;
import org.apache.causeway.viewer.wicket.model.models.BookmarkableModel;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.jspecify.annotations.NonNull;

public class BookmarkTreeNode
implements Comparable<BookmarkTreeNode>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<BookmarkTreeNode> children = _Lists.newArrayList();
    private final int depth;
    private final @NonNull Bookmark bookmark;
    private final @NonNull PageParameters pageParameters;
    private String title;
    private ResourceReference iconResourceReference;
    private FontAwesomeLayers faLayers;

    public static BookmarkTreeNode newRoot(@NonNull Bookmark bookmark, @NonNull BookmarkableModel bookmarkableModel) {
        return new BookmarkTreeNode(bookmark, bookmarkableModel, 0);
    }

    private BookmarkTreeNode(@NonNull Bookmark bookmark, @NonNull BookmarkableModel bookmarkableModel, int depth) {
        this.pageParameters = bookmarkableModel.getPageParametersWithoutUiHints();
        this.bookmark = bookmark;
        this.title = bookmarkableModel.getTitle();
        _Casts.castTo(UiObjectWkt.class, (Object)bookmarkableModel).map(UiObjectWkt::getIconAsResourceReference).ifPresent(either -> either.accept(iconResourceReference -> {
            this.iconResourceReference = iconResourceReference;
        }, faLayers -> {
            this.faLayers = faLayers;
        }));
        this.depth = depth;
    }

    public Either<ResourceReference, FontAwesomeLayers> eitherIconOrFaClass() {
        return this.faLayers == null ? Either.left((Object)this.iconResourceReference) : Either.right((Object)this.faLayers);
    }

    @Override
    public int compareTo(BookmarkTreeNode o2) {
        String typeName2;
        BookmarkTreeNode o1 = this;
        String typeName1 = o1.getBookmark().logicalTypeName();
        int typeNameComparison = typeName1.compareTo(typeName2 = o2.getBookmark().logicalTypeName());
        if (typeNameComparison != 0) {
            return typeNameComparison;
        }
        return o1.getTitle().compareTo(o2.getTitle());
    }

    public boolean matches(BookmarkableModel candidateBookmarkableModel) {
        if (candidateBookmarkableModel instanceof UiObjectWkt) {
            return this.matchAndUpdateTitleFor((UiObjectWkt)candidateBookmarkableModel);
        }
        return false;
    }

    public void appendGraphTo(List<BookmarkTreeNode> list) {
        list.add(this);
        for (BookmarkTreeNode childNode : this.children) {
            childNode.appendGraphTo(list);
        }
    }

    private Optional<BookmarkTreeNode> addChild(BookmarkableModel childModel) {
        return childModel.toBookmark().map(bookmark -> new BookmarkTreeNode((Bookmark)bookmark, childModel, this.depth + 1)).map(_Functions.peek(this.children::add));
    }

    private boolean matchAndUpdateTitleFor(UiObjectWkt candidateEntityModel) {
        Bookmark candidateBookmark = candidateEntityModel.toBookmark().orElse(null);
        boolean inGraph = this.getBookmark().equals(candidateBookmark);
        if (inGraph) {
            this.title = candidateEntityModel.getTitle();
        }
        if (candidateEntityModel.getBookmarkPolicy().isChild()) {
            for (BookmarkTreeNode childNode : this.getChildren()) {
                inGraph = childNode.matches(candidateEntityModel) || inGraph;
            }
            if (!inGraph) {
                inGraph = this.addToGraphIfParented(candidateEntityModel);
            }
        }
        return inGraph;
    }

    private boolean addToGraphIfParented(BookmarkableModel candidateBookmarkableModel) {
        LongAdder addedCount = new LongAdder();
        candidateBookmarkableModel.streamPropertyBookmarks().filter(arg_0 -> ((Bookmark)this.getBookmark()).equals(arg_0)).forEach(propBookmark -> {
            if (this.addChild(candidateBookmarkableModel).isPresent()) {
                addedCount.increment();
            }
        });
        return addedCount.longValue() > 0L;
    }

    @Generated
    public List<BookmarkTreeNode> getChildren() {
        return this.children;
    }

    @Generated
    public int getDepth() {
        return this.depth;
    }

    @Generated
    public @NonNull Bookmark getBookmark() {
        return this.bookmark;
    }

    @Generated
    public @NonNull PageParameters getPageParameters() {
        return this.pageParameters;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }
}

