/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.models;

import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.MmUnwrapUtils;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.jspecify.annotations.NonNull;
import org.springframework.util.ClassUtils;

record ScalarUnwrapper<T>(Class<T> type, UiAttributeWkt attributeModel) {
    public ScalarUnwrapper(@NonNull Class<T> type, @NonNull UiAttributeWkt attributeModel) {
        this.type = type;
        this.attributeModel = attributeModel;
        _Assert.assertTrue((boolean)attributeModel.getElementType().isAssignableFrom(type), () -> String.format("cannot possibly unwrap model of type %s into target type %s", attributeModel.getElementType().getCorrespondingClass(), type));
    }

    public T getObject() {
        ManagedObject objectAdapter = this.attributeModel().getObject();
        T pojo = this.unwrap(objectAdapter);
        return pojo;
    }

    public void setObject(T object) {
        UiAttributeWkt attributeModel = this.attributeModel();
        if (object == null) {
            attributeModel.setObject(null);
        } else {
            ManagedObject objectAdapter = attributeModel.getMetaModelContext().getObjectManager().adapt(object);
            attributeModel.setObject(objectAdapter);
        }
    }

    private T unwrap(ManagedObject objectAdapter) {
        Object pojo = MmUnwrapUtils.single((ManagedObject)objectAdapter);
        if (pojo == null || !ClassUtils.resolvePrimitiveIfNecessary(this.type).isAssignableFrom(ClassUtils.resolvePrimitiveIfNecessary(pojo.getClass()))) {
            return null;
        }
        return (T)_Casts.uncheckedCast((Object)pojo);
    }
}

