/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns;

import java.io.Serializable;
import org.apache.causeway.applib.services.i18n.TranslationContext;
import org.apache.causeway.core.metamodel.context.HasMetaModelContext;
import org.apache.causeway.core.metamodel.tabular.interactive.DataRow;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.interaction.coll.DataRowWkt;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.causeway.viewer.wicket.ui.app.registry.HasComponentFactoryRegistry;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.GenericColumn;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.TitleColumn;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.ToggleboxColumn;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class GenericColumnAbstract
extends AbstractColumn<DataRow, String>
implements GenericColumn,
HasMetaModelContext {
    private static final long serialVersionUID = 1L;
    private transient ComponentFactoryRegistry componentRegistry;

    protected GenericColumnAbstract(String columnName) {
        this((IModel<String>)Model.of((Serializable)((Object)columnName)), null);
    }

    protected GenericColumnAbstract(IModel<String> columnNameModel, String sortColumn) {
        super(columnNameModel, (Object)sortColumn);
    }

    public final void populateItem(Item<ICellPopulator<DataRow>> cellItem, String componentId, IModel<DataRow> rowModel) {
        cellItem.add(new Component[]{this.createCellComponent(componentId, (DataRow)rowModel.getObject(), (IModel<Boolean>)((DataRowWkt)rowModel).getDataRowToggle())});
        if (this instanceof TitleColumn) {
            Wkt.cssAppend(cellItem, "title-column");
            if (((TitleColumn)this).isTitleSuppressed()) {
                Wkt.cssAppend(cellItem, "title-suppressed");
            }
        } else if (this instanceof ToggleboxColumn) {
            Wkt.cssAppend(cellItem, "togglebox-column");
            MarkupContainer row = cellItem.getParent().getParent();
            row.setOutputMarkupId(true);
        }
    }

    protected abstract Component createCellComponent(String var1, DataRow var2, IModel<Boolean> var3);

    protected ComponentFactory findComponentFactory(UiComponentType uiComponentType, IModel<?> model) {
        return this.getComponentRegistry().findComponentFactory(uiComponentType, model);
    }

    protected ComponentFactoryRegistry getComponentRegistry() {
        if (this.componentRegistry == null) {
            HasComponentFactoryRegistry componentFactoryRegistryAccessor = (HasComponentFactoryRegistry)Application.get();
            this.componentRegistry = componentFactoryRegistryAccessor.getComponentFactoryRegistry();
        }
        return this.componentRegistry;
    }

    protected String translate(String raw) {
        return this.getMetaModelContext().getTranslationService().translate(TranslationContext.empty(), raw);
    }
}

