/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collectioncontents.export;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.Supplier;
import org.apache.causeway.applib.services.registry.ServiceRegistry;
import org.apache.causeway.applib.value.NamedWithMimeType;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.core.metamodel.tabular.simple.CollectionContentsExporter;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.causeway.viewer.wicket.ui.CollectionContentsAsFactory;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.ComponentFactoryAbstract;
import org.apache.causeway.viewer.wicket.ui.app.registry.ComponentFactoryKey;
import org.apache.causeway.viewer.wicket.ui.components.download.FileDownloadLink;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.link.DownloadLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.file.Files;

@org.springframework.stereotype.Component
public class CollectionContentsAsExportFactory
extends ComponentFactoryAbstract
implements CollectionContentsAsFactory {
    private final CollectionContentsExporter collectionContentsExporter;

    public CollectionContentsAsExportFactory(CollectionContentsExporter collectionContentsExporter) {
        super(UiComponentType.COLLECTION_CONTENTS_EXPORT, collectionContentsExporter.getClass().getName(), DownloadLink.class);
        this.collectionContentsExporter = collectionContentsExporter;
    }

    @Override
    public ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
        if (!(model instanceof EntityCollectionModel)) {
            return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
        }
        EntityCollectionModel collectionModel = (EntityCollectionModel)model;
        return this.collectionContentsExporter.appliesTo(collectionModel.getElementType()) ? ComponentFactory.ApplicationAdvice.APPLIES : ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
    }

    @Override
    public Component createComponent(String id, IModel<?> model) {
        EntityCollectionModel collectionModel = (EntityCollectionModel)model;
        NamedWithMimeType.CommonMimeType mimeType = this.collectionContentsExporter.getMimeType();
        String ext = (String)mimeType.getProposedFileExtensions().getFirstElseFail();
        String fileName = collectionModel.getName().replaceAll(" ", "") + "." + ext;
        FileDownloadLink link = new FileDownloadLink(id, mimeType, fileName, new FileModel(this, collectionModel, fileName));
        return link;
    }

    @Override
    public IModel<String> getTitleLabel() {
        return Model.of((Serializable)((Object)this.collectionContentsExporter.getTitleLabel()));
    }

    @Override
    public IModel<String> getCssClass() {
        return Model.of((Serializable)((Object)this.collectionContentsExporter.getCssClass()));
    }

    @Override
    public int orderOfAppearanceInUiDropdown() {
        return this.collectionContentsExporter.orderOfAppearanceInUiDropdown();
    }

    static class FileModel
    implements IModel<File> {
        private static final long serialVersionUID = 1L;
        private ComponentFactoryKey key;
        private EntityCollectionModel model;
        private String fileName;

        FileModel(CollectionContentsAsExportFactory x, EntityCollectionModel model, String fileName) {
            this.key = x.key();
            this.model = model;
            this.fileName = fileName;
        }

        public File getObject() {
            File tempFile = File.createTempFile(CollectionContentsAsExportFactory.class.getCanonicalName(), this.fileName);
            Try.run(() -> this.exporter().createExport(this.model.getDataTableModel().export(), tempFile)).ifFailure(__ -> Files.remove((File)tempFile)).ifFailureFail();
            return tempFile;
        }

        private CollectionContentsExporter exporter() {
            return ((CollectionContentsAsExportFactory)this.key.resolve((Supplier<ServiceRegistry>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getServiceRegistry(), ()Lorg/apache/causeway/applib/services/registry/ServiceRegistry;)((EntityCollectionModel)this.model))).collectionContentsExporter;
        }
    }
}

