/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.pages.standalonecollection;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.causeway.applib.services.publishing.spi.PageRenderSubscriber;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.object.Bookmarkable;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.EntityCollectionModelStandalone;
import org.apache.causeway.viewer.wicket.model.util.PageParameterUtils;
import org.apache.causeway.viewer.wicket.ui.pages.PageAbstract;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.model.IModel;

@AuthorizeInstantiation(value={"org.apache.causeway.security.AUTHORIZED_USER_ROLE"})
public class StandaloneCollectionPage
extends PageAbstract {
    private static final long serialVersionUID = 1L;
    private final EntityCollectionModelStandalone collectionModel;

    public StandaloneCollectionPage(EntityCollectionModelStandalone collectionModel) {
        super(PageParameterUtils.newPageParameters(), collectionModel.getName(), UiComponentType.STANDALONE_COLLECTION);
        this.collectionModel = collectionModel;
        this.addChildComponents(this.themeDiv, (IModel<?>)collectionModel);
        this.addBookmarkedPages(this.themeDiv);
    }

    @Override
    public void onRendered(Can<PageRenderSubscriber> objectRenderSubscribers) {
        if (objectRenderSubscribers.isEmpty()) {
            return;
        }
        List bookmarks = ((Can)this.collectionModel.getObject().getDataElements().getValue()).stream().map(Bookmarkable::getBookmark).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toUnmodifiableList());
        objectRenderSubscribers.forEach(subscriber -> subscriber.onRenderedCollection(() -> bookmarks));
    }
}

