/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.util;

import java.io.Serializable;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.NonNull;
import org.apache.causeway.applib.fa.FontAwesomeLayers;
import org.apache.causeway.applib.services.i18n.TranslationService;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.viewer.commons.model.decorators.ConfirmDecorator;
import org.apache.causeway.viewer.commons.model.layout.UiPlacementDirection;
import org.apache.causeway.viewer.wicket.model.links.LinkAndLabel;
import org.apache.causeway.viewer.wicket.ui.components.widgets.linkandlabel.ActionLink;
import org.apache.causeway.viewer.wicket.ui.util.BootstrapConstants;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktDecorators;
import org.apache.causeway.viewer.wicket.ui.util.WktTooltips;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.springframework.lang.Nullable;

public final class WktLinks {
    public static <T extends Page> AbstractLink newBookmarkablePageLink(String linkId, PageParameters pageParameters, Class<T> pageClass) {
        return new BookmarkablePageLink(linkId, pageClass, pageParameters);
    }

    public static AbstractLink asAdditionalLink(Component tooltipReceiver, String titleId, LinkAndLabel linkAndLabel, boolean isForceAlignmentWithBlankIcon) {
        AjaxLink link = linkAndLabel.getUiComponent();
        ObjectAction action = linkAndLabel.getManagedAction().getAction();
        boolean hasDisabledReason = link instanceof ActionLink && _Strings.isNotEmpty((CharSequence)((ActionLink)link).getReasonDisabledIfAny());
        WktTooltips.addTooltip(tooltipReceiver, hasDisabledReason ? ((ActionLink)link).getReasonDisabledIfAny() : (String)linkAndLabel.getDescription().orElse(null));
        if (ObjectAction.Util.returnsBlobOrClob((ObjectAction)action)) {
            Wkt.cssAppend(link, "noVeil");
        }
        if (action.isPrototype()) {
            Wkt.cssAppend(link, "prototype");
        }
        Wkt.cssAppend(link, linkAndLabel.getFeatureIdentifier());
        if (action.getSemantics().isAreYouSure()) {
            if (action.getParameterCount() == 0 && !hasDisabledReason) {
                TranslationService translationService = linkAndLabel.getAction().getMetaModelContext().getTranslationService();
                ConfirmDecorator.ConfirmDecorationModel confirmUiModel = ConfirmDecorator.ConfirmDecorationModel.areYouSure((TranslationService)translationService, (UiPlacementDirection)UiPlacementDirection.BOTTOM);
                WktDecorators.getConfirm().decorate((Component)link, confirmUiModel);
            }
            WktDecorators.getDanger().decorate((Component)link);
        } else {
            Wkt.cssAppend(link, linkAndLabel.isRenderOutlined() || action.isPrototype() ? BootstrapConstants.ButtonSemantics.SECONDARY.buttonOutlineCss() : BootstrapConstants.ButtonSemantics.SECONDARY.buttonDefaultCss());
        }
        linkAndLabel.getAdditionalCssClass().ifPresent(cssClass -> Wkt.cssAppend(link, cssClass));
        Label viewTitleLabel = Wkt.labelAdd((MarkupContainer)link, titleId, (IModel<String>)((IModel & Serializable)() -> ((LinkAndLabel)linkAndLabel).getFriendlyName()));
        Optional faLayers = linkAndLabel.lookupFontAwesomeLayers(isForceAlignmentWithBlankIcon);
        WktDecorators.getIcon().decorate((Component)viewTitleLabel, (Optional<FontAwesomeLayers>)faLayers);
        WktDecorators.getMissingIcon().decorate((Component)viewTitleLabel, (Optional<FontAwesomeLayers>)faLayers);
        return link;
    }

    public static <T, R extends MarkupContainer> R listItemAsDropdownLink(@NonNull ListItem<T> item, @NonNull R container, @NonNull String titleId, @NonNull Function<T, IModel<String>> titleProvider, @NonNull String iconId, @Nullable Function<T, IModel<String>> iconProvider, @Nullable BiFunction<T, Label, IModel<String>> cssFactory) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (container == null) {
            throw new NullPointerException("container is marked non-null but is null");
        }
        if (titleId == null) {
            throw new NullPointerException("titleId is marked non-null but is null");
        }
        if (titleProvider == null) {
            throw new NullPointerException("titleProvider is marked non-null but is null");
        }
        if (iconId == null) {
            throw new NullPointerException("iconId is marked non-null but is null");
        }
        Object t = item.getModelObject();
        Wkt.labelAdd(container, titleId, titleProvider.apply(t));
        Label viewItemIcon = Wkt.labelAdd(container, iconId, (IModel<String>)Optional.ofNullable(iconProvider).map(iconProv -> (IModel)iconProv.apply(t)).orElseGet(() -> Model.of((Serializable)((Object)""))));
        Optional.ofNullable(cssFactory).map(cssFact -> (IModel)cssFact.apply(t, viewItemIcon)).ifPresent(cssModel -> Wkt.cssAppend(viewItemIcon, (IModel<String>)cssModel));
        return container;
    }

    private WktLinks() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

