/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.app.registry;

import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.causeway.commons.collections.ImmutableEnumSet;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.model.IModel;
import org.springframework.lang.Nullable;

public interface ComponentFactoryRegistry {
    public Stream<ComponentFactory> streamComponentFactories(UiComponentType var1, @Nullable IModel<?> var2);

    public Stream<ComponentFactory> streamComponentFactories(ImmutableEnumSet<UiComponentType> var1, @Nullable IModel<?> var2);

    default public ComponentFactory findComponentFactory(UiComponentType uiComponentType, @Nullable IModel<?> model) {
        return this.streamComponentFactories(uiComponentType, model).findFirst().orElseGet(() -> this.streamComponentFactories(UiComponentType.UNKNOWN, model).findFirst().orElse(null));
    }

    default public ComponentFactory findComponentFactoryElseFail(UiComponentType uiComponentType, @Nullable IModel<?> model) {
        return this.streamComponentFactories(uiComponentType, model).findFirst().orElseThrow(() -> new RuntimeException(String.format("could not find component for componentType = '%s'; model object is of type %s; model object='%s'", uiComponentType, model.getClass().getName(), model.getObject())));
    }

    public Component addOrReplaceComponent(MarkupContainer var1, UiComponentType var2, IModel<?> var3);

    public Component addOrReplaceComponent(MarkupContainer var1, String var2, UiComponentType var3, IModel<?> var4);

    public Component createComponent(UiComponentType var1, IModel<?> var2);

    public Component createComponent(String var1, UiComponentType var2, IModel<?> var3);

    public <T extends ComponentFactory> Optional<T> lookupFactory(Class<T> var1);

    default public <T extends ComponentFactory> T lookupFactoryElseFail(Class<T> factoryClass) {
        return (T)((ComponentFactory)this.lookupFactory(factoryClass).orElseThrow(() -> new NoSuchElementException("Could not locate component factory of type '" + factoryClass + "'")));
    }
}

