/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.actions;

import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.apache.causeway.applib.services.i18n.TranslationService;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.functional.Either;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.core.metamodel.interactions.managed.ParameterNegotiationModel;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.commons.model.decorators.ConfirmDecorator;
import org.apache.causeway.viewer.commons.model.layout.UiPlacementDirection;
import org.apache.causeway.viewer.commons.model.scalar.UiParameter;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.model.models.ScalarParameterModel;
import org.apache.causeway.viewer.wicket.model.models.ScalarPropertyModel;
import org.apache.causeway.viewer.wicket.model.models.interaction.act.UiParameterWkt;
import org.apache.causeway.viewer.wicket.ui.components.actions._Xray;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.causeway.viewer.wicket.ui.panels.PromptFormAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktDecorators;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;

class ActionParametersForm
extends PromptFormAbstract<ActionModel> {
    private static final long serialVersionUID = 1L;

    public ActionParametersForm(String id, Component parentPanel, ActionModel actionModel) {
        super(id, parentPanel, actionModel);
    }

    protected ActionModel actionModel() {
        return (ActionModel)super.getModel();
    }

    @Override
    protected void addParameters() {
        ActionModel actionModel = this.actionModel();
        RepeatingView repeatingView = Wkt.add((MarkupContainer)this, new RepeatingView("parameters"));
        this.paramPanels.clear();
        actionModel.streamPendingParamUiModels().map(UiParameterWkt.class::cast).forEach(paramModel -> {
            WebMarkupContainer container = Wkt.containerAdd((MarkupContainer)repeatingView, repeatingView.newChildId());
            this.newParamPanel(container, (UiParameterWkt)paramModel, this.paramPanels::add);
        });
        this.setOutputMarkupId(true);
    }

    private void newParamPanel(WebMarkupContainer container, UiParameterWkt paramModel, Consumer<ScalarPanelAbstract> onNewScalarPanel) {
        ScalarParameterModel scalarParamModel = ScalarParameterModel.wrap((UiParameterWkt)paramModel);
        Component component = this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)container, "scalarNameAndValue", UiComponentType.SCALAR_NAME_AND_VALUE, (IModel<?>)scalarParamModel);
        _Casts.castTo(ScalarPanelAbstract.class, (Object)component).ifPresent(scalarPanel -> {
            scalarPanel.addChangeListener(this);
            onNewScalarPanel.accept((ScalarPanelAbstract)scalarPanel);
        });
    }

    @Override
    protected void configureOkButton(AjaxButton okButton) {
        this.applyAreYouSure(okButton);
    }

    private void applyAreYouSure(AjaxButton button) {
        ActionModel actionModel = this.actionModel();
        ObjectAction action = actionModel.getAction();
        if (action.getSemantics().isAreYouSure()) {
            ConfirmDecorator.ConfirmDecorationModel confirmUiModel = ConfirmDecorator.ConfirmDecorationModel.areYouSure((TranslationService)this.getTranslationService(), (UiPlacementDirection)UiPlacementDirection.BOTTOM);
            WktDecorators.getConfirm().decorate((Component)button, confirmUiModel);
        }
    }

    @Override
    public void onUpdate(AjaxRequestTarget target, ScalarPanelAbstract scalarPanelUpdated) {
        ActionModel actionModel = this.actionModel();
        UiParameter updatedParamModel = (UiParameter)scalarPanelUpdated.getModel();
        ParameterNegotiationModel paramNegotiationModel = updatedParamModel.getParameterNegotiationModel();
        Can pendingParamModels = (Can)actionModel.streamPendingParamUiModels().collect(Can.toCan());
        int paramIndexOfUpdated = updatedParamModel.getParameterIndex();
        _Xray.beforeParamFormUpdate(paramIndexOfUpdated, paramNegotiationModel);
        IntStream.range(paramIndexOfUpdated + 1, paramNegotiationModel.getParamCount()).forEach(paramIndexForReassessment -> {
            boolean wasValueChanged = paramNegotiationModel.reassessDefaults(paramIndexForReassessment);
            ScalarPanelAbstract.Repaint paramRepaint = ScalarPanelAbstract.Repaint.required(wasValueChanged);
            _Xray.reassessedDefault(paramIndexForReassessment, paramNegotiationModel);
            ScalarPanelAbstract paramPanel = (ScalarPanelAbstract)this.paramPanels.get(paramIndexForReassessment);
            UiParameter paramModel = (UiParameter)pendingParamModels.getElseFail(paramIndexForReassessment);
            paramRepaint = paramRepaint.max(paramPanel.updateIfNecessary(paramModel));
            switch (paramRepaint) {
                case REQUIRED: {
                    target.add(new Component[]{paramPanel});
                    break;
                }
                case REQUIRED_ON_PARENT: {
                    target.add(new Component[]{paramPanel.getParent()});
                    break;
                }
            }
        });
        _Xray.afterParamFormUpdate(paramIndexOfUpdated, paramNegotiationModel);
    }

    @Override
    protected Either<ActionModel, ScalarPropertyModel> getMemberModel() {
        return Either.left((Object)this.actionModel());
    }
}

