/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.table;

import java.util.List;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.tabular.DataRow;
import org.apache.causeway.viewer.wicket.model.itemreuse.ReuseIfRowIndexEqualsStrategy;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.CollectionContentsSortableDataProvider;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.ToggleboxColumn;
import org.apache.causeway.viewer.wicket.ui.components.table.DataTableWithPagesAndFilter;
import org.apache.causeway.viewer.wicket.ui.components.table.head.HeadersToolbar;
import org.apache.causeway.viewer.wicket.ui.components.table.nav.NavigationToolbar;
import org.apache.causeway.viewer.wicket.ui.components.table.nonav.TotalRecordsToolbar;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.NoRecordsToolbar;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;

public class CausewayAjaxDataTable
extends DataTableWithPagesAndFilter<DataRow, String> {
    private static final long serialVersionUID = 1L;
    private final CollectionContentsSortableDataProvider dataProvider;
    private final ToggleboxColumn toggleboxColumn;

    public CausewayAjaxDataTable(String id, List<? extends IColumn<DataRow, String>> columns, CollectionContentsSortableDataProvider dataProvider, int rowsPerPage, ToggleboxColumn toggleboxColumn) {
        super(id, columns, dataProvider, rowsPerPage);
        this.dataProvider = dataProvider;
        this.toggleboxColumn = toggleboxColumn;
        this.setItemReuseStrategy((IItemReuseStrategy)ReuseIfRowIndexEqualsStrategy.getInstance());
    }

    protected void onInitialize() {
        super.onInitialize();
        this.buildGui();
    }

    private void buildGui() {
        CausewayConfiguration.Viewer.Wicket wicketConfig = MetaModelContext.instanceElseFail().getConfiguration().getViewer().getWicket();
        this.addTopToolbar(new HeadersToolbar(this, this.dataProvider, wicketConfig));
        if (!this.isDecoratedWithDataTablesNet()) {
            this.addBottomToolbar((AbstractToolbar)new NavigationToolbar(this, this.toggleboxColumn));
            this.addBottomToolbar((AbstractToolbar)new NoRecordsToolbar((DataTable)this));
            this.addBottomToolbar(new TotalRecordsToolbar(this));
        }
    }

    public boolean isDecoratedWithDataTablesNet() {
        IDataProvider dataProvider = this.getDataProvider();
        return dataProvider instanceof CollectionContentsSortableDataProvider && ((CollectionContentsSortableDataProvider)dataProvider).isDecoratedWithDataTablesNet();
    }

    protected Item<DataRow> newRowItem(String id, int index, IModel<DataRow> model) {
        return Wkt.oddEvenItem(id, index, model, CausewayAjaxDataTable::cssClassForRow);
    }

    private static String cssClassForRow(DataRow model) {
        if (model == null || ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)model.getRowElement())) {
            return null;
        }
        ManagedObject rowElement = model.getRowElement();
        return rowElement.getSpecification().getCssClass(rowElement);
    }
}

