/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.util;

import de.agilecoders.wicket.core.markup.html.bootstrap.components.PopoverBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.PopoverConfig;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipConfig;
import de.agilecoders.wicket.jquery.Config;
import java.io.Serializable;
import java.time.Duration;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.core.config.viewer.web.TextMode;
import org.apache.causeway.core.metamodel.context.HasMetaModelContext;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.viewer.commons.model.decorators.TooltipDecorator;
import org.apache.causeway.viewer.commons.model.layout.UiPlacementDirection;
import org.apache.causeway.viewer.wicket.ui.components.widgets.linkandlabel.ActionLink;
import org.apache.causeway.viewer.wicket.ui.util.ExtendedPopoverConfig;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktComponents;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.springframework.lang.Nullable;

public final class WktTooltips {
    public static <T extends Component> T addTooltip(@Nullable T target, @Nullable TooltipDecorator.TooltipDecorationModel tooltipDecorationModel) {
        ActionLink actionLink;
        if (target == null || tooltipDecorationModel == null || tooltipDecorationModel.isEmpty()) {
            return target;
        }
        if (target instanceof ActionLink && !(actionLink = (ActionLink)target).getActionModel().hasParameters()) {
            throw _Exceptions.illegalArgument((String)"Adding a tooltip to an ActionLink will break any ConfirmationBehavior, that's also applied to same ActionLink!", (Object[])new Object[0]);
        }
        UiPlacementDirection placementDirection = tooltipDecorationModel.getPlacementDirection();
        Model bodyModel = Model.of((Serializable)((Object)tooltipDecorationModel.getBody()));
        TooltipBehavior tooltipBehavior = tooltipDecorationModel.getTitle().map(title -> Model.of((Serializable)((Object)title))).map(arg_0 -> WktTooltips.lambda$addTooltip$1(placementDirection, (IModel)bodyModel, arg_0)).orElseGet(() -> WktTooltips.lambda$addTooltip$2(placementDirection, (IModel)bodyModel));
        target.add(new Behavior[]{tooltipBehavior});
        Wkt.cssAppend(target, "wkt-component-with-tooltip");
        return target;
    }

    public static void clearTooltip(@Nullable Component target) {
        if (target == null) {
            return;
        }
        target.getBehaviors(TooltipBehavior.class).forEach(xva$0 -> target.remove(new Behavior[]{xva$0}));
    }

    public static <T extends Component> T addTooltip(@Nullable T target, @Nullable String body) {
        return WktTooltips.addTooltip(UiPlacementDirection.BOTTOM, target, body);
    }

    public static <T extends Component> T addTooltip(@Nullable T target, @Nullable String title, @Nullable String body) {
        return WktTooltips.addTooltip(UiPlacementDirection.BOTTOM, target, title, body);
    }

    public static <T extends Component> T addTooltip(@NonNull UiPlacementDirection uiPlacementDirection, @Nullable T target, @Nullable String body) {
        if (uiPlacementDirection == null) {
            throw new NullPointerException("uiPlacementDirection is marked non-null but is null");
        }
        return WktTooltips.addTooltip(target, _Strings.isEmpty((CharSequence)body) ? null : TooltipDecorator.TooltipDecorationModel.ofBody((UiPlacementDirection)uiPlacementDirection, (String)WktTooltips.preprocess(body)));
    }

    public static <T extends Component> T addTooltip(@NonNull UiPlacementDirection uiPlacementDirection, @Nullable T target, @Nullable String title, @Nullable String body) {
        if (uiPlacementDirection == null) {
            throw new NullPointerException("uiPlacementDirection is marked non-null but is null");
        }
        return WktTooltips.addTooltip(target, TooltipDecorator.TooltipDecorationModel.ofTitleAndBody((UiPlacementDirection)uiPlacementDirection, (String)title, (String)WktTooltips.preprocess(body)));
    }

    private static TooltipBehavior createTooltipBehavior(@NonNull UiPlacementDirection uiPlacementDirection, @NonNull IModel<String> titleLabel, @NonNull IModel<String> bodyLabel) {
        if (uiPlacementDirection == null) {
            throw new NullPointerException("uiPlacementDirection is marked non-null but is null");
        }
        if (titleLabel == null) {
            throw new NullPointerException("titleLabel is marked non-null but is null");
        }
        if (bodyLabel == null) {
            throw new NullPointerException("bodyLabel is marked non-null but is null");
        }
        return WktTooltips.createPopoverBehavior(titleLabel, bodyLabel, WktTooltips.getTooltipConfig(uiPlacementDirection));
    }

    private static TooltipBehavior createTooltipBehavior(@NonNull UiPlacementDirection uiPlacementDirection, @NonNull IModel<String> bodyLabel) {
        if (uiPlacementDirection == null) {
            throw new NullPointerException("uiPlacementDirection is marked non-null but is null");
        }
        if (bodyLabel == null) {
            throw new NullPointerException("bodyLabel is marked non-null but is null");
        }
        return WktTooltips.createPopoverBehavior((IModel<String>)Model.of(), bodyLabel, WktTooltips.getTooltipConfig(uiPlacementDirection));
    }

    private static PopoverBehavior createPopoverBehavior(IModel<String> titleLabel, IModel<String> bodyLabel, PopoverConfig config) {
        return new PopoverBehavior(titleLabel, bodyLabel, config){
            private static final long serialVersionUID = 1L;

            protected CharSequence createInitializerScript(Component component, Config config) {
                CharSequence markupId = WktComponents.getMarkupId(component);
                return String.format("document.querySelectorAll('#%s').forEach((elem)=>{new bootstrap.Popover(elem, %s);})", markupId, config.toJsonString());
            }
        };
    }

    private static PopoverConfig getTooltipConfig(UiPlacementDirection uiPlacementDirection) {
        switch (uiPlacementDirection) {
            case TOP: {
                return WktTooltips.createPopoverConfigDefault().withPlacement((TooltipConfig.IPlacement)TooltipConfig.Placement.top);
            }
            case RIGHT: {
                return WktTooltips.createPopoverConfigDefault().withPlacement((TooltipConfig.IPlacement)TooltipConfig.Placement.right);
            }
            case BOTTOM: {
                return WktTooltips.createPopoverConfigDefault().withPlacement((TooltipConfig.IPlacement)TooltipConfig.Placement.bottom);
            }
            case LEFT: {
                return WktTooltips.createPopoverConfigDefault().withPlacement((TooltipConfig.IPlacement)TooltipConfig.Placement.left);
            }
        }
        throw _Exceptions.unmatchedCase((Object)uiPlacementDirection);
    }

    private static PopoverConfig createPopoverConfigDefault() {
        TextMode textMode = WktTooltips.getTooltipTextMode();
        return new ExtendedPopoverConfig().withBoundary(ExtendedPopoverConfig.PopoverBoundary.viewport).withTrigger(TooltipConfig.OpenTrigger.hover).withDelay(Duration.ZERO).withAnimation(true).withHtml(textMode.isHtml()).withSanitizer(!textMode.isHtml());
    }

    private static TextMode getTooltipTextMode() {
        TextMode textMode = MetaModelContext.instance().map(HasMetaModelContext::getConfiguration).map(cfg -> cfg.getViewer().getWicket().getTooltipTextMode()).orElseGet(TextMode::defaults);
        return textMode;
    }

    private static String preprocess(@Nullable String string) {
        return _Strings.nonEmpty((CharSequence)string).map(s -> WktTooltips.getTooltipTextMode().isHtml() ? WktTooltips.replaceNewlineWithHtmlBR(s) : s).orElse(string);
    }

    private static String replaceNewlineWithHtmlBR(@NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        return s.replace("\r", "").replace("\n", "<br/>");
    }

    @Generated
    private WktTooltips() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static /* synthetic */ TooltipBehavior lambda$addTooltip$2(UiPlacementDirection placementDirection, IModel bodyModel) {
        return WktTooltips.createTooltipBehavior(placementDirection, (IModel<String>)bodyModel);
    }

    private static /* synthetic */ TooltipBehavior lambda$addTooltip$1(UiPlacementDirection placementDirection, IModel bodyModel, Model titleModel) {
        return WktTooltips.createTooltipBehavior(placementDirection, (IModel<String>)titleModel, (IModel<String>)bodyModel);
    }
}

