/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.scalars.choices;

import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.viewer.wicket.model.models.ScalarModel;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ComponentFactoryScalarAbstract;
import org.apache.causeway.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.causeway.viewer.wicket.ui.components.scalars.choices.ObjectChoicesSelect2Panel;
import org.apache.causeway.viewer.wicket.ui.components.scalars.choices.ValueChoicesSelect2Panel;
import org.apache.causeway.viewer.wicket.ui.components.scalars.string.ScalarTitleBadgePanel;

public class ChoicesSelect2PanelFactory
extends ComponentFactoryScalarAbstract {
    public ChoicesSelect2PanelFactory() {
        super(ScalarPanelAbstract.class);
    }

    protected ScalarPanelAbstract createComponent(String id, ScalarModel scalarModel) {
        ComponentSort componentSort = ComponentSort.valueOf(scalarModel);
        switch (componentSort) {
            case TITLE_BADGE: {
                Class valueType = scalarModel.getElementType().getCorrespondingClass();
                return new ScalarTitleBadgePanel(id, scalarModel, valueType);
            }
            case VALUE_CHOICES: {
                return new ValueChoicesSelect2Panel(id, scalarModel);
            }
            case OBJECT_CHOICES: {
                return new ObjectChoicesSelect2Panel(id, scalarModel);
            }
        }
        throw _Exceptions.unmatchedCase((Object)((Object)componentSort));
    }

    @Override
    protected ComponentFactory.ApplicationAdvice appliesTo(ScalarModel scalarModel) {
        return ComponentFactory.ApplicationAdvice.APPLIES;
    }

    private static enum ComponentSort {
        TITLE_BADGE,
        VALUE_CHOICES,
        OBJECT_CHOICES;


        static ComponentSort valueOf(ScalarModel scalarModel) {
            if (scalarModel.getElementType().isValue() && scalarModel.getChoiceProviderSort().isChoicesAny()) {
                return scalarModel.isViewingMode() ? TITLE_BADGE : VALUE_CHOICES;
            }
            return OBJECT_CHOICES;
        }
    }
}

