/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.scalars.image;

import java.awt.image.BufferedImage;
import java.util.Optional;
import lombok.NonNull;
import org.apache.causeway.applib.value.Blob;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.core.metamodel.valuesemantics.ImageValueSemantics;
import org.apache.causeway.viewer.wicket.model.models.ScalarModel;
import org.apache.wicket.extensions.markup.html.image.resource.ThumbnailImageResource;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.image.NonCachingImage;
import org.apache.wicket.markup.html.image.resource.BufferedDynamicImageResource;
import org.apache.wicket.request.resource.IResource;
import org.springframework.lang.Nullable;

final class _WktImageUtil {
    public static Optional<Image> asWicketImage(@NonNull String id, @Nullable BufferedImage buffImg) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (buffImg == null) {
            return Optional.empty();
        }
        BufferedDynamicImageResource imageResource = new BufferedDynamicImageResource();
        imageResource.setImage(buffImg);
        ThumbnailImageResource thumbnailImageResource = new ThumbnailImageResource((IResource)imageResource, 300);
        NonCachingImage wicketImage = new NonCachingImage(id, (IResource)thumbnailImageResource);
        wicketImage.setOutputMarkupId(true);
        return Optional.of(wicketImage);
    }

    public static Optional<Image> asWicketImage(@NonNull String id, @Nullable Blob blob) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        BufferedImage buffImg = Optional.ofNullable(blob).flatMap(Blob::asImage).orElse(null);
        return _WktImageUtil.asWicketImage(id, buffImg);
    }

    public static Optional<Image> asWicketImage(@NonNull String id, @NonNull ScalarModel model) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        ManagedObject adapter = model.getObject();
        if (ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)adapter)) {
            return Optional.empty();
        }
        ObjectSpecification typeSpec = model.getElementType();
        return Facets.valueStreamSemantics((ObjectSpecification)typeSpec, ImageValueSemantics.class).map(imageValueSemantics -> imageValueSemantics.getImage(adapter).orElse(null)).filter(_NullSafe::isPresent).map(buffImg -> _WktImageUtil.asWicketImage(id, buffImg).orElse(null)).filter(_NullSafe::isPresent).findFirst();
    }

    private _WktImageUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

