/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns;

import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.spec.feature.ObjectMember;
import org.apache.causeway.core.metamodel.tabular.DataRow;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.model.models.ValueModel;
import org.apache.causeway.viewer.wicket.model.models.interaction.coll.DataRowWkt;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.ColumnAbbreviationOptions;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.GenericColumnAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.springframework.lang.Nullable;

public final class TitleColumn
extends GenericColumnAbstract {
    private static final long serialVersionUID = 1L;
    private final EntityCollectionModel.Variant variant;
    private final ColumnAbbreviationOptions opts;
    private final Bookmark contextBookmark;

    public TitleColumn(EntityCollectionModel.Variant variant, Bookmark contextBookmark, int maxColumnTitleLength, ColumnAbbreviationOptions opts) {
        super(TitleColumn.columnName(variant, maxColumnTitleLength));
        this.variant = variant;
        this.contextBookmark = contextBookmark;
        this.opts = opts;
    }

    @Override
    protected Component createCellComponent(String componentId, DataRowWkt dataRowWkt) {
        DataRow dataRow = dataRowWkt.getObject();
        ManagedObject rowElement = dataRow.getRowElement();
        if (ManagedObjects.isValue((ManagedObject)rowElement)) {
            ObjectMember objectMember = dataRow.getParentTable().getMetaModel();
            ValueModel valueModel = ValueModel.of((ObjectMember)objectMember, (ManagedObject)rowElement);
            ComponentFactory componentFactory = this.findComponentFactory(UiComponentType.VALUE, (IModel<?>)valueModel);
            return componentFactory.createComponent(componentId, (IModel<?>)valueModel);
        }
        UiObjectWkt uiObject = UiObjectWkt.ofAdapterForCollection((ManagedObject)rowElement, (EntityCollectionModel.Variant)this.variant);
        uiObject.setContextBookmarkIfAny(this.contextBookmark);
        ComponentFactory componentFactory = this.findComponentFactory(UiComponentType.ENTITY_LINK, (IModel<?>)uiObject);
        Component entityLink = this.opts.applyTo(componentFactory.createComponent(componentId, (IModel<?>)uiObject));
        return entityLink;
    }

    boolean isTitleSuppressed() {
        return this.opts.getMaxElementTitleLength() <= 3;
    }

    private static String columnName(@Nullable EntityCollectionModel.Variant variant, int maxTitleLength) {
        if (maxTitleLength == 0) {
            return "";
        }
        return (variant.isParented() ? "Related " : "") + "Object";
    }
}

