/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns;

import java.io.Serializable;
import java.util.List;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.core.metamodel.tabular.DataTableInteractive;
import org.apache.causeway.viewer.wicket.model.models.interaction.coll.DataRowToggleWkt;
import org.apache.causeway.viewer.wicket.model.models.interaction.coll.DataRowWkt;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.BulkToggleWkt;
import org.apache.causeway.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.GenericColumnAbstract;
import org.apache.causeway.viewer.wicket.ui.components.widgets.checkbox.ContainedToggleboxPanel;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.IModel;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;

public final class ToggleboxColumn
extends GenericColumnAbstract {
    private static final long serialVersionUID = 1L;
    private final IModel<DataTableInteractive> dataTableModelHolder;
    private final List<ContainedToggleboxPanel> rowToggles = _Lists.newArrayList();

    public ToggleboxColumn(IModel<DataTableInteractive> dataTableModelHolder) {
        super("");
        this.dataTableModelHolder = dataTableModelHolder;
    }

    public void removeToggles() {
        this.rowToggles.clear();
    }

    @Override
    protected Component createCellComponent(String componentId, DataRowWkt dataRowWkt) {
        DataRowToggleWkt dataRowToggle = new DataRowToggleWkt(dataRowWkt);
        ContainedToggleboxPanel rowToggle = new ContainedToggleboxPanel(componentId, (IModel<Boolean>)dataRowToggle);
        this.rowToggles.add(rowToggle);
        return rowToggle.setOutputMarkupId(true);
    }

    public Component getHeader(String componentId) {
        ContainedToggleboxPanel bulkToggle = new ContainedToggleboxPanel(componentId, (IModel<Boolean>)new BulkToggleWkt(this.dataTableModelHolder), (SerializableBiConsumer<Boolean, AjaxRequestTarget>)((SerializableBiConsumer & Serializable)this::onBulkUpdate));
        Wkt.cssAppend(bulkToggle, "togglebox-column");
        return bulkToggle;
    }

    private void onBulkUpdate(Boolean isChecked, AjaxRequestTarget target) {
        DataTableInteractive dataTableInteractive = (DataTableInteractive)this.dataTableModelHolder.getObject();
        dataTableInteractive.doProgrammaticToggle(() -> {
            BulkToggle bulkToggle = BulkToggle.valueOf(isChecked);
            for (ContainedToggleboxPanel rowToggle : this.rowToggles) {
                rowToggle.set(bulkToggle, target);
            }
        });
    }

    public static enum BulkToggle {
        CLEAR_ALL,
        SET_ALL;


        static BulkToggle valueOf(boolean b) {
            return b ? SET_ALL : CLEAR_ALL;
        }

        public boolean isSetAll() {
            return this == SET_ALL;
        }
    }
}

