/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.pages.accmngt;

import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.functions._Functions;
import org.apache.wicket.util.cookies.CookieUtils;
import org.springframework.lang.Nullable;

public final class SuccessFeedbackCookieManager {
    static final String FEEDBACK_COOKIE_NAME = "causeway.feedback.success";

    public static void storeSuccessFeedback(@Nullable String successFeedback) {
        CookieUtils cookieUtils = new CookieUtils();
        if (_Strings.isNotEmpty((CharSequence)successFeedback)) {
            cookieUtils.save(FEEDBACK_COOKIE_NAME, _Strings.base64UrlEncode((String)successFeedback));
        } else {
            SuccessFeedbackCookieManager.drainSuccessFeedback(_Functions.noopConsumer());
        }
    }

    public static void drainSuccessFeedback(@NonNull Consumer<String> onSuccessFeedback) {
        if (onSuccessFeedback == null) {
            throw new NullPointerException("onSuccessFeedback is marked non-null but is null");
        }
        CookieUtils cookieUtils = new CookieUtils();
        String successFeedback = cookieUtils.load(FEEDBACK_COOKIE_NAME);
        if (_Strings.isNotEmpty((CharSequence)successFeedback)) {
            onSuccessFeedback.accept(_Strings.base64UrlDecode((String)successFeedback));
        }
        cookieUtils.remove(FEEDBACK_COOKIE_NAME);
    }

    @Generated
    private SuccessFeedbackCookieManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

