/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.attributes;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.fileinput.BootstrapFileInputField;
import java.io.Serializable;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.applib.services.placeholder.PlaceholderRenderService;
import org.apache.causeway.commons.internal.functions._Functions;
import org.apache.causeway.core.metamodel.interactions.managed.InteractionVeto;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedValue;
import org.apache.causeway.viewer.commons.model.components.UiString;
import org.apache.causeway.viewer.wicket.model.models.FormExecutorContext;
import org.apache.causeway.viewer.wicket.model.models.InlinePromptContext;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributeFragmentFactory;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributePanel;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributePanelAdditionalButton;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributePanelWithFormField;
import org.apache.causeway.viewer.wicket.ui.components.attributes._Util;
import org.apache.causeway.viewer.wicket.ui.components.widgets.actionlink.ActionLink;
import org.apache.causeway.viewer.wicket.ui.components.widgets.links.AjaxLinkNoPropagate;
import org.apache.causeway.viewer.wicket.ui.panels.FormExecutorDefault;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktTooltips;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.springframework.lang.Nullable;

public abstract class AttributePanelWithInlinePrompt
extends AttributePanel {
    private static final long serialVersionUID = 1L;
    protected MarkupContainer fieldFrame;
    protected WebMarkupContainer inlinePromptLink;

    protected AttributePanelWithInlinePrompt(String id, UiAttributeWkt attributeModel) {
        super(id, attributeModel);
    }

    @Override
    protected final void setupInlinePrompt() {
        UiAttributeWkt attributeModel = this.attributeModel();
        MarkupContainer regularFrame = this.getRegularFrame();
        MarkupContainer fieldFrame = this.getFieldFrame();
        WebMarkupContainer scalarFrameContainer = this.getScalarFrameContainer();
        attributeModel.setInlinePromptContext(new InlinePromptContext(attributeModel, (MarkupContainer)scalarFrameContainer, (Component)regularFrame, this.getFormFrame()));
        AttributeFragmentFactory.FieldFragment.matching(fieldFrame).ifPresent(fieldFragment -> {
            switch (fieldFragment) {
                case LINK_TO_PROMT: {
                    Component[] componentArray = new Component[1];
                    this.inlinePromptLink = this.createInlinePromptLink();
                    componentArray[0] = this.inlinePromptLink;
                    fieldFrame.addOrReplace(componentArray);
                    this.addOnClickBehaviorTo((MarkupContainer)this.inlinePromptLink);
                    RepeatingView additionalButtonContainer = fieldFragment.createButtonContainer((MarkupContainer)this.inlinePromptLink);
                    this.addAdditionalButtonsTo(additionalButtonContainer, (AttributeFragmentFactory.FieldFragment)((Object)fieldFragment));
                    return;
                }
                case NO_LINK_VIEWING: 
                case NO_LINK_EDITING: {
                    RepeatingView additionalButtonContainer = fieldFragment.createButtonContainer(fieldFrame);
                    this.addAdditionalButtonsTo(additionalButtonContainer, (AttributeFragmentFactory.FieldFragment)((Object)fieldFragment));
                    return;
                }
            }
        });
        if (fieldFrame != null && fieldFrame.get("scalarValue") == null) {
            Wkt.labelAdd(fieldFrame, "scalarValue", "\u2205");
        }
    }

    protected Component createComponentForOutput(String id) {
        if (this.isUsingTextarea()) {
            return AttributeFragmentFactory.PromptFragment.TEXTAREA.createFragment(id, (MarkupContainer)this, scalarValueId -> {
                TextArea<String> textArea = Wkt.textAreaNoTab(scalarValueId, (IModel<String>)((IModel & Serializable)this::outputFormatAsString));
                UiAttributeWkt attributeModel = this.attributeModel();
                Wkt.setFormComponentAttributes(textArea, () -> ((UiAttributeWkt)attributeModel).multilineNumberOfLines(), () -> ((UiAttributeWkt)attributeModel).maxLength(), () -> ((UiAttributeWkt)attributeModel).typicalLength());
                return textArea;
            });
        }
        return AttributeFragmentFactory.CompactFragment.LABEL.createFragment(id, (MarkupContainer)this, scalarValueId -> Wkt.labelWithDynamicEscaping(scalarValueId, (_Functions.SerializableSupplier<UiString>)((_Functions.SerializableSupplier & Serializable)this::obtainOutputFormat)));
    }

    private boolean isUsingTextarea() {
        if (this.getRenderScenario().isCompact() || this.getFormatModifiers().contains((Enum)AttributePanel.FormatModifier.MARKUP) || !this.getFormatModifiers().contains((Enum)AttributePanel.FormatModifier.MULTILINE)) {
            return false;
        }
        return !this.attributeModel().isEmpty();
    }

    protected final String outputFormatAsString() {
        return this.obtainOutputFormat().getString();
    }

    protected UiString obtainOutputFormat() {
        ManagedValue proposedValue = this.attributeModel().proposedValue();
        if (!proposedValue.isPresent()) {
            return UiString.markup((String)this.getPlaceholderRenderService().asHtml(PlaceholderRenderService.PlaceholderLiteral.NULL_REPRESENTATION));
        }
        return this.isUsingTextarea() || this.getFormatModifiers().contains((Enum)AttributePanel.FormatModifier.TEXT_ONLY) ? UiString.text((String)((String)proposedValue.getValueAsTitle().getValue())) : UiString.markup((String)((String)proposedValue.getValueAsHtml().getValue()));
    }

    protected void onSwitchFormForInlinePrompt(WebMarkupContainer inlinePromptForm, AjaxRequestTarget target) {
    }

    protected void configureInlinePromptLink(WebMarkupContainer inlinePromptLink) {
        Wkt.cssAppend(inlinePromptLink, this.obtainInlinePromptLinkCssIfAny());
    }

    protected String obtainInlinePromptLinkCssIfAny() {
        return "form-control form-control-sm";
    }

    @Override
    protected void onMakeNotEditable(String disableReason) {
        this.setupInlinePrompt();
    }

    @Override
    protected void onMakeEditable() {
        this.setupInlinePrompt();
    }

    private void addOnClickBehaviorTo(@Nullable MarkupContainer clickReceiver) {
        if (clickReceiver == null) {
            return;
        }
        UiAttributeWkt attributeModel = this.attributeModel();
        if (_Util.canPropertyEnterInlineEditDirectly(attributeModel)) {
            _Util.lookupMixinForCompositeValueUpdate(attributeModel).ifPresentOrElse(mixinForCompositeValueEdit -> {
                ActionLink actionLink = ActionLink.create(mixinForCompositeValueEdit);
                Wkt.behaviorAddOnClick((Component)clickReceiver, (SerializableConsumer<AjaxRequestTarget>)((SerializableConsumer & Serializable)actionLink::onClick));
            }, () -> Wkt.behaviorAddOnClick((Component)clickReceiver, (SerializableConsumer<AjaxRequestTarget>)((SerializableConsumer & Serializable)this::onPropertyInlineEditClick)));
        } else {
            _Util.lookupPropertyActionForInlineEdit(attributeModel).ifPresent(actionLinkInlineAsIfEdit -> {
                ActionLink actionLink = ActionLink.create(actionLinkInlineAsIfEdit);
                Wkt.behaviorAddOnClick((Component)clickReceiver, (SerializableConsumer<AjaxRequestTarget>)((SerializableConsumer & Serializable)actionLink::onClick));
            });
        }
    }

    private void addAdditionalButtonsTo(@NonNull RepeatingView buttonContainer, AttributeFragmentFactory.FieldFragment fieldFragment) {
        if (buttonContainer == null) {
            throw new NullPointerException("buttonContainer is marked non-null but is null");
        }
        block6: for (AttributePanelAdditionalButton additionalButton : AttributePanelAdditionalButton.values()) {
            if (!additionalButton.isVisible(this.attributeModel(), this.getRenderScenario(), fieldFragment)) continue;
            switch (additionalButton) {
                case COPY_TO_CLIPBOARD: {
                    continue block6;
                }
                case DISABLED_REASON: {
                    this.addDisabledReasonIcon(buttonContainer, "fa-solid fa-ban veto-reason-icon", "");
                    continue block6;
                }
                case DISABLED_REASON_PROTOTYPING: {
                    this.addDisabledReasonIcon(buttonContainer, "fa-solid fa-text-slash veto-reason-icon prototyping", "\nNote: This icon only appears in prototyping mode (unless disabled via config option causeway.viewer.wicket.disable-reason-explanation-in-prototyping-mode-enabled).");
                    continue block6;
                }
                case CLEAR_FIELD: {
                    this.addClearFieldButton(buttonContainer);
                    continue block6;
                }
            }
        }
    }

    private void addDisabledReasonIcon(@NonNull RepeatingView buttonContainer, @NonNull String faClass, @NonNull String reasonSuffix) {
        if (buttonContainer == null) {
            throw new NullPointerException("buttonContainer is marked non-null but is null");
        }
        if (faClass == null) {
            throw new NullPointerException("faClass is marked non-null but is null");
        }
        if (reasonSuffix == null) {
            throw new NullPointerException("reasonSuffix is marked non-null but is null");
        }
        AjaxLinkNoPropagate disableReasonButton = Wkt.linkAddWithBody(buttonContainer, Wkt.faIcon(faClass), (SerializableConsumer<AjaxRequestTarget>)(SerializableConsumer & Serializable)ajaxTarget -> {});
        String disabledReason = this.attributeModel().disabledReason().flatMap(InteractionVeto::getReasonAsString).orElse("framework bug: should provide a reason");
        WktTooltips.addTooltip(disableReasonButton, this.translate(disabledReason) + this.translate(reasonSuffix));
        Wkt.noTabbing((Component)disableReasonButton);
        if (this.attributeModel().isParameter()) {
            disableReasonButton.setEventPropagation(AjaxRequestAttributes.EventPropagation.BUBBLE);
        }
    }

    private void addClearFieldButton(@NonNull RepeatingView buttonContainer) {
        if (buttonContainer == null) {
            throw new NullPointerException("buttonContainer is marked non-null but is null");
        }
        AjaxLinkNoPropagate clearFieldButton = Wkt.linkAddWithBody(buttonContainer, Wkt.faIcon("fa-regular fa-trash-can"), (SerializableConsumer<AjaxRequestTarget>)((SerializableConsumer & Serializable)this::onClearFieldButtonClick));
        Wkt.cssAppend(clearFieldButton, "btn-warning");
        WktTooltips.addTooltip(clearFieldButton, this.translate("Click to clear the field"));
        if (this.attributeModel().isParameter()) {
            clearFieldButton.setEventPropagation(AjaxRequestAttributes.EventPropagation.BUBBLE);
        }
    }

    private WebMarkupContainer createInlinePromptLink() {
        WebMarkupContainer inlinePromptLink = AttributeFragmentFactory.FieldFrame.SCALAR_VALUE_INLINE_PROMPT_LINK.createComponent(WebMarkupContainer::new);
        inlinePromptLink.setOutputMarkupId(true);
        inlinePromptLink.setOutputMarkupPlaceholderTag(true);
        this.configureInlinePromptLink(inlinePromptLink);
        Wkt.add((MarkupContainer)inlinePromptLink, AttributeFragmentFactory.FieldFrame.SCALAR_VALUE_CONTAINER.createComponent(id -> this.createComponentForOutput((String)id)));
        return inlinePromptLink;
    }

    private void onPropertyInlineEditClick(AjaxRequestTarget target) {
        this.attributeModel().toEditingMode();
        this.switchRegularFrameToFormFrame();
        this.onSwitchFormForInlinePrompt(this.getFormFrame(), target);
        target.add(new Component[]{this.getScalarFrameContainer()});
        Wkt.focusOnMarkerAttribute((MarkupContainer)this.getFormFrame(), target);
        Wkt.javaScriptAdd(target, Wkt.EventTopic.FOCUS_FIRST_PARAMETER, this.getMarkupId());
    }

    private void onClearFieldButtonClick(AjaxRequestTarget target) {
        this.attributeModel().proposedValue().clear();
        this.attributeModel().getSpecialization().accept(param -> {
            this.clearBootstrapFileInputField();
            this.setupInlinePrompt();
            target.add(new Component[]{this});
        }, prop -> FormExecutorDefault.forProperty(prop).executeAndProcessResults(target, null, (FormExecutorContext)prop));
    }

    private void clearBootstrapFileInputField() {
        AttributePanelWithFormField formContainer;
        FormComponent formComponent;
        if (this instanceof AttributePanelWithFormField && (formComponent = (formContainer = (AttributePanelWithFormField)this).getFormComponent()) instanceof BootstrapFileInputField) {
            FormComponent replacement = formContainer.createFormComponent(formComponent.getId(), this.attributeModel());
            formComponent.replaceWith(replacement);
        }
    }

    @Generated
    protected MarkupContainer getFieldFrame() {
        return this.fieldFrame;
    }
}

