/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.attributes.choices;

import java.io.Serializable;
import java.util.function.Function;
import lombok.NonNull;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.commons.model.attrib.UiParameter;
import org.apache.causeway.viewer.commons.model.components.UiString;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributePanel;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributePanelWithFormField;
import org.apache.causeway.viewer.wicket.ui.components.widgets.select2.Select2;
import org.apache.causeway.viewer.wicket.ui.components.widgets.select2.providers.ChoiceProviderAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.springframework.lang.Nullable;
import org.wicketstuff.select2.Settings;

public abstract class AttributePanelWithSelect
extends AttributePanelWithFormField<ManagedObject> {
    private static final long serialVersionUID = 1L;
    protected Select2 select2;

    protected AttributePanelWithSelect(String id, UiAttributeWkt attributeModel) {
        super(id, attributeModel, ManagedObject.class);
        this.setOutputMarkupId(true);
    }

    protected final Select2 createSelect2(String id, Function<UiAttributeWkt, ChoiceProviderAbstract> choiceProviderFactory) {
        UiAttributeWkt attributeModel = this.attributeModel();
        Select2 select2 = Select2.createSelect2(id, attributeModel, choiceProviderFactory.apply(attributeModel), this.getAttributeModelChangeDispatcher());
        Settings settings = select2.getSettings();
        settings.setPlaceholder((Object)attributeModel.getFriendlyName());
        switch (attributeModel.getChoiceProviderSort()) {
            case CHOICES: {
                break;
            }
            case AUTO_COMPLETE: {
                settings.setMinimumInputLength(Integer.valueOf(attributeModel.getAutoCompleteMinLength()));
                break;
            }
            case OBJECT_AUTO_COMPLETE: {
                Facets.autoCompleteMinLength((ObjectSpecification)attributeModel.getElementType()).ifPresent(arg_0 -> ((Settings)settings).setMinimumInputLength(arg_0));
                break;
            }
        }
        return select2;
    }

    @Override
    protected final void installModelChangeBehavior() {
    }

    protected final boolean isEditable() {
        UiAttributeWkt attributeModel = this.attributeModel();
        return !attributeModel.getRenderingHint().isInTable() && !attributeModel.isViewingMode();
    }

    protected final boolean hasAnyChoices() {
        return this.attributeModel().getChoiceProviderSort().isChoicesAny();
    }

    public final boolean checkSelect2Required() {
        return this.select2.checkRequired();
    }

    @Override
    protected final UiString obtainOutputFormat() {
        return UiString.text((String)((String)this.select2.obtainOutputFormatModel().getObject()));
    }

    @Override
    protected final void onSwitchFormForInlinePrompt(WebMarkupContainer inlinePromptForm, AjaxRequestTarget target) {
        Wkt.javaScriptAdd(target, Wkt.EventTopic.OPEN_SELECT2, inlinePromptForm.getMarkupId());
    }

    @Override
    public final AttributePanel.Repaint updateIfNecessary(@NonNull UiParameter paramModel) {
        if (paramModel == null) {
            throw new NullPointerException("paramModel is marked non-null but is null");
        }
        return super.updateIfNecessary(paramModel).max(AttributePanel.Repaint.required(this.select2 != null));
    }

    public static interface ChoiceTitleHandler
    extends Serializable {
        public void clearTitleAttribute();

        public void setTitleAttribute(@Nullable String var1);
    }
}

