/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.attributes.choices;

import java.io.Serializable;
import java.util.Optional;
import org.apache.causeway.applib.services.placeholder.PlaceholderRenderService;
import org.apache.causeway.commons.binding.Bindable;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributeFragmentFactory;
import org.apache.causeway.viewer.wicket.ui.components.attributes.choices.AttributePanelWithSelect;
import org.apache.causeway.viewer.wicket.ui.components.attributes.choices.ChoiceFormComponent;
import org.apache.causeway.viewer.wicket.ui.components.widgets.objectsimplelink.ObjectLinkSimplePanel;
import org.apache.causeway.viewer.wicket.ui.components.widgets.select2.providers.ChoiceProviderDefault;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktComponents;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

class ObjectChoicesAttributePanel
extends AttributePanelWithSelect
implements AttributePanelWithSelect.ChoiceTitleHandler {
    private static final long serialVersionUID = 1L;
    private static final String ID_AUTO_COMPLETE = "autoComplete";
    private static final String ID_OBJECT_TITLE_IF_NULL = "objectTitleIfNull";
    private ChoiceFormComponent objectLink;
    private ObjectLinkSimplePanel objectLinkOutputFormat;
    private final boolean isCompactFormat;

    public ObjectChoicesAttributePanel(String id, UiAttributeWkt attributeModel) {
        super(id, attributeModel);
        this.isCompactFormat = attributeModel.getRenderingHint().isInTable();
    }

    @Override
    protected Component createComponentForOutput(String id) {
        UiAttributeWkt attributeModel = this.attributeModel();
        String name = attributeModel.getFriendlyName();
        this.objectLinkOutputFormat = (ObjectLinkSimplePanel)this.getComponentFactoryRegistry().createComponent(UiComponentType.OBJECT_LINK, (IModel<?>)attributeModel);
        this.objectLinkOutputFormat.setOutputMarkupId(true);
        this.objectLinkOutputFormat.setLabel((IModel)Model.of((Serializable)((Object)name)));
        return AttributeFragmentFactory.CompactFragment.OBJECT_LINK.createFragment(id, (MarkupContainer)this, scalarValueId -> this.objectLinkOutputFormat);
    }

    @Override
    protected FormComponent<ManagedObject> createFormComponent(String id, UiAttributeWkt attributeModel) {
        this.objectLink = new ChoiceFormComponent(UiComponentType.OBJECT_LINK.getId(), this);
        this.objectLink.setRequired(attributeModel.isRequired());
        this.select2 = this.createSelect2(ID_AUTO_COMPLETE, ChoiceProviderDefault::new);
        this.objectLink.addOrReplace(new Component[]{this.select2.asComponent()});
        this.objectLink.setOutputMarkupId(true);
        return this.objectLink;
    }

    @Override
    protected final Optional<AttributeFragmentFactory.InputFragment> getInputFragmentType() {
        return Optional.of(AttributeFragmentFactory.InputFragment.SELECT_OBJECT);
    }

    @Override
    protected void onInitializeEditable() {
        super.onInitializeEditable();
        this.syncWithInput();
    }

    @Override
    protected void onInitializeNotEditable() {
        super.onInitializeNotEditable();
        this.syncWithInput();
    }

    @Override
    protected void onInitializeReadonly(String disableReason) {
        super.onInitializeReadonly(disableReason);
        this.syncWithInput();
    }

    @Override
    protected void onMakeNotEditable(String disableReason) {
        super.onMakeNotEditable(disableReason);
        if (this.isCompactFormat) {
            return;
        }
        this.setTitleAttribute(disableReason);
    }

    @Override
    protected void onMakeEditable() {
        super.onMakeEditable();
        if (this.isCompactFormat) {
            return;
        }
        this.clearTitleAttribute();
    }

    private Optional<MarkupContainer> lookupScalarValueContainer() {
        return Optional.ofNullable(this.getFieldFrame()).flatMap(AttributeFragmentFactory.FieldFrame.SCALAR_VALUE_CONTAINER::lookupIn).map(MarkupContainer.class::cast);
    }

    private void syncWithInput() {
        if (this.isCompactFormat) {
            return;
        }
        UiAttributeWkt attributeModel = this.attributeModel();
        this.lookupScalarValueContainer().ifPresent(container -> {
            ManagedObject adapter;
            ComponentFactory componentFactory = this.getComponentFactoryRegistry().findComponentFactory(UiComponentType.OBJECT_ICON_AND_TITLE, (IModel<?>)attributeModel);
            Component iconAndTitle = componentFactory.createComponent(UiComponentType.OBJECT_ICON_AND_TITLE.getId(), (IModel<?>)attributeModel);
            container.addOrReplace(new Component[]{iconAndTitle});
            boolean isInlinePrompt = attributeModel.isInlinePrompt();
            if (isInlinePrompt) {
                iconAndTitle.setVisible(false);
            }
            if ((adapter = attributeModel.getObject()) != null || isInlinePrompt) {
                WktComponents.permanentlyHide(container, ID_OBJECT_TITLE_IF_NULL);
            } else {
                Wkt.markupAdd(container, ID_OBJECT_TITLE_IF_NULL, this.getPlaceholderRenderService().asHtml(PlaceholderRenderService.PlaceholderLiteral.NULL_REPRESENTATION));
            }
        });
        if (!this.isEditable()) {
            WktComponents.permanentlyHide((MarkupContainer)this.objectLink, ID_AUTO_COMPLETE);
            return;
        }
        if (this.fieldFrame != null) {
            WktComponents.permanentlyHide(this.fieldFrame, ID_OBJECT_TITLE_IF_NULL);
        }
        WktComponents.permanentlyHide((MarkupContainer)this.objectLink, ID_OBJECT_TITLE_IF_NULL);
        if (this.select2 == null) {
            throw new IllegalStateException("select2 should be created already");
        }
        this.select2.setEnabled(this.objectLink.isEnableAllowed() && !((UiAttributeWkt)this.getModel()).isViewingMode());
        if (!this.hasAnyChoices()) {
            // empty if block
        }
    }

    String getTitleForFormComponentInput() {
        ManagedObject pendingElseCurrentAdapter = this.attributeModel().getObject();
        return pendingElseCurrentAdapter != null ? pendingElseCurrentAdapter.getTitle() : "(no object)";
    }

    void convertInput() {
        UiAttributeWkt attributeModel = this.attributeModel();
        Bindable pendingValue = attributeModel.proposedValue().getValue();
        if (this.isEditable()) {
            ManagedObject adapter = this.select2.getConvertedInputValue();
            pendingValue.setValue((Object)adapter);
        }
        this.objectLink.setConvertedInput((ManagedObject)pendingValue.getValue());
    }

    @Override
    public void clearTitleAttribute() {
        this.objectLink.setEnabled(true);
        Wkt.attributeReplace(this.objectLink, "title", "");
    }

    @Override
    public void setTitleAttribute(String titleAttribute) {
        if (_Strings.isNullOrEmpty((CharSequence)titleAttribute)) {
            this.clearTitleAttribute();
            return;
        }
        this.objectLink.setEnabled(false);
        Wkt.attributeReplace(this.objectLink, "title", titleAttribute);
    }
}

