/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns;

import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.causeway.applib.services.linking.DeepLinkService;
import org.apache.causeway.applib.services.placeholder.PlaceholderRenderService;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectMember;
import org.apache.causeway.core.metamodel.tabular.DataColumn;
import org.apache.causeway.core.metamodel.tabular.DataRow;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.model.models.ValueModel;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModel;
import org.apache.causeway.viewer.wicket.model.models.coll.DataRowWkt;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns.AssociationColumnAbstract;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns.ColumnAbbreviationOptions;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;

public final class PluralColumn
extends AssociationColumnAbstract {
    private static final long serialVersionUID = 1L;
    private final RenderOptions opts;

    public PluralColumn(ObjectSpecification elementType, CollectionModel.Variant collectionVariant, IModel<String> columnNameModel, String propertyId, String parentTypeName, Optional<String> describedAs, RenderOptions opts) {
        super(elementType, collectionVariant, columnNameModel, Optional.empty(), propertyId, parentTypeName, describedAs);
        this.opts = opts;
    }

    @Override
    protected Component createCellComponent(String componentId, DataRowWkt dataRowWkt) {
        DataColumn dataColumn;
        DataRow dataRow = dataRowWkt.getObject();
        Can cellElements = dataRow.getCellElementsForColumn(dataColumn = (DataColumn)dataRow.lookupColumnById(this.memberId).orElseThrow());
        if (cellElements.isEmpty()) {
            return Wkt.markup(componentId, this.opts.isRenderEmptyBadge() ? this.getPlaceholderRenderService().asHtml(PlaceholderRenderService.PlaceholderLiteral.NULL_REPRESENTATION) : "");
        }
        RepeatingView container = new RepeatingView(componentId);
        cellElements.stream().limit(this.opts.maxElements()).forEach(cellElement -> container.add(new Component[]{this.createCellElementComponent(container.newChildId(), dataColumn, (ManagedObject)cellElement)}));
        int overflow = cellElements.size() - this.opts.maxElements();
        if (overflow > 0) {
            String href = this.getMetaModelContext().getServiceRegistry().lookupService(DeepLinkService.class).map(deepLinkService -> deepLinkService.deepLinkFor((Object)dataRow.rowElement())).map(URI::toString).orElse("#");
            Wkt.markupAdd((MarkupContainer)container, container.newChildId(), this.getPlaceholderRenderService().asHtml(PlaceholderRenderService.PlaceholderLiteral.HAS_MORE, Map.of("number", "" + overflow, "href", href)));
        }
        return container;
    }

    private Component createCellElementComponent(String componentId, DataColumn dataColumn, ManagedObject cellElement) {
        if (ManagedObjects.isValue((ManagedObject)cellElement)) {
            ValueModel valueModel = ValueModel.of((ObjectMember)dataColumn.associationMetaModel(), (ManagedObject)cellElement);
            ComponentFactory componentFactory = this.findComponentFactory(UiComponentType.VALUE, (IModel<?>)valueModel);
            return componentFactory.createComponent(componentId, (IModel<?>)valueModel);
        }
        UiObjectWkt uiObject = UiObjectWkt.ofAdapterForCollection((ManagedObject)cellElement, (CollectionModel.Variant)this.collectionVariant);
        ComponentFactory componentFactory = this.findComponentFactory(UiComponentType.OBJECT_LINK, (IModel<?>)uiObject);
        Component objectLink = componentFactory.createComponent(componentId, (IModel<?>)uiObject);
        ColumnAbbreviationOptions.builder().maxElementTitleLength(this.opts.titleAbbreviationThreshold()).build().applyTo(objectLink);
        return objectLink;
    }

    public static final class RenderOptions
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int titleAbbreviationThreshold;
        private final int maxElements;
        private final boolean isRenderEmptyBadge;

        @Generated
        private static int $default$titleAbbreviationThreshold() {
            return 50;
        }

        @Generated
        private static int $default$maxElements() {
            return 5;
        }

        @Generated
        private static boolean $default$isRenderEmptyBadge() {
            return true;
        }

        @Generated
        RenderOptions(int titleAbbreviationThreshold, int maxElements, boolean isRenderEmptyBadge) {
            this.titleAbbreviationThreshold = titleAbbreviationThreshold;
            this.maxElements = maxElements;
            this.isRenderEmptyBadge = isRenderEmptyBadge;
        }

        @Generated
        public static RenderOptionsBuilder builder() {
            return new RenderOptionsBuilder();
        }

        @Generated
        public int titleAbbreviationThreshold() {
            return this.titleAbbreviationThreshold;
        }

        @Generated
        public int maxElements() {
            return this.maxElements;
        }

        @Generated
        public boolean isRenderEmptyBadge() {
            return this.isRenderEmptyBadge;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RenderOptions)) {
                return false;
            }
            RenderOptions other = (RenderOptions)o;
            if (this.titleAbbreviationThreshold() != other.titleAbbreviationThreshold()) {
                return false;
            }
            if (this.maxElements() != other.maxElements()) {
                return false;
            }
            return this.isRenderEmptyBadge() == other.isRenderEmptyBadge();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.titleAbbreviationThreshold();
            result = result * 59 + this.maxElements();
            result = result * 59 + (this.isRenderEmptyBadge() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "PluralColumn.RenderOptions(titleAbbreviationThreshold=" + this.titleAbbreviationThreshold() + ", maxElements=" + this.maxElements() + ", isRenderEmptyBadge=" + this.isRenderEmptyBadge() + ")";
        }

        @Generated
        public static class RenderOptionsBuilder {
            @Generated
            private boolean titleAbbreviationThreshold$set;
            @Generated
            private int titleAbbreviationThreshold$value;
            @Generated
            private boolean maxElements$set;
            @Generated
            private int maxElements$value;
            @Generated
            private boolean isRenderEmptyBadge$set;
            @Generated
            private boolean isRenderEmptyBadge$value;

            @Generated
            RenderOptionsBuilder() {
            }

            @Generated
            public RenderOptionsBuilder titleAbbreviationThreshold(int titleAbbreviationThreshold) {
                this.titleAbbreviationThreshold$value = titleAbbreviationThreshold;
                this.titleAbbreviationThreshold$set = true;
                return this;
            }

            @Generated
            public RenderOptionsBuilder maxElements(int maxElements) {
                this.maxElements$value = maxElements;
                this.maxElements$set = true;
                return this;
            }

            @Generated
            public RenderOptionsBuilder isRenderEmptyBadge(boolean isRenderEmptyBadge) {
                this.isRenderEmptyBadge$value = isRenderEmptyBadge;
                this.isRenderEmptyBadge$set = true;
                return this;
            }

            @Generated
            public RenderOptions build() {
                int titleAbbreviationThreshold$value = this.titleAbbreviationThreshold$value;
                if (!this.titleAbbreviationThreshold$set) {
                    titleAbbreviationThreshold$value = RenderOptions.$default$titleAbbreviationThreshold();
                }
                int maxElements$value = this.maxElements$value;
                if (!this.maxElements$set) {
                    maxElements$value = RenderOptions.$default$maxElements();
                }
                boolean isRenderEmptyBadge$value = this.isRenderEmptyBadge$value;
                if (!this.isRenderEmptyBadge$set) {
                    isRenderEmptyBadge$value = RenderOptions.$default$isRenderEmptyBadge();
                }
                return new RenderOptions(titleAbbreviationThreshold$value, maxElements$value, isRenderEmptyBadge$value);
            }

            @Generated
            public String toString() {
                return "PluralColumn.RenderOptions.RenderOptionsBuilder(titleAbbreviationThreshold$value=" + this.titleAbbreviationThreshold$value + ", maxElements$value=" + this.maxElements$value + ", isRenderEmptyBadge$value=" + this.isRenderEmptyBadge$value + ")";
            }
        }
    }
}

