/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.download;

import java.io.File;
import org.apache.causeway.applib.value.NamedWithMimeType;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.link.DownloadLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.encoding.UrlEncoder;

public class FileDownloadLink
extends DownloadLink {
    private static final long serialVersionUID = 1L;
    private final NamedWithMimeType.CommonMimeType mime;
    private final String fileName;

    public FileDownloadLink(String id, NamedWithMimeType.CommonMimeType mime, String fileName, IModel<File> model) {
        super(id, model, fileName);
        this.mime = mime;
        this.fileName = fileName;
    }

    public void onClick() {
        Wkt.fileDownloadClickHandler((IModel<File>)this.getModel(), this.mime, this.fileName);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        String encodedFileName = UrlEncoder.QUERY_INSTANCE.encode(this.fileName, this.getRequest().getCharset());
        tag.put("download", (CharSequence)encodedFileName);
    }
}

