/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.layout.bs.col;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.causeway.applib.layout.component.CollectionLayoutData;
import org.apache.causeway.applib.layout.component.DomainObjectLayoutData;
import org.apache.causeway.applib.layout.component.FieldSet;
import org.apache.causeway.applib.layout.grid.bootstrap.BSCol;
import org.apache.causeway.applib.layout.grid.bootstrap.BSRow;
import org.apache.causeway.applib.layout.grid.bootstrap.BSTab;
import org.apache.causeway.applib.layout.grid.bootstrap.BSTabGroup;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.components.actionlinks.entityactions.ActionLinksPanel;
import org.apache.causeway.viewer.wicket.ui.components.collection.parented.ParentedCollectionPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.layout.bs.col.RepeatingViewWithDynamicallyVisibleContent;
import org.apache.causeway.viewer.wicket.ui.components.layout.bs.row.Row;
import org.apache.causeway.viewer.wicket.ui.components.layout.bs.tabs.TabGroupPanel;
import org.apache.causeway.viewer.wicket.ui.components.object.fieldset.PropertyGroup;
import org.apache.causeway.viewer.wicket.ui.panels.HasDynamicallyVisibleContent;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktComponents;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class Col
extends PanelAbstract<ManagedObject, UiObjectWkt>
implements HasDynamicallyVisibleContent {
    private static final long serialVersionUID = 1L;
    private static final String ID_COL = "col";
    private static final String ID_OBJECT_HEADER_PANEL = "objectHeaderPanel";
    private static final String ID_ROWS = "rows";
    private static final String ID_TAB_GROUPS = "tabGroups";
    private static final String ID_FIELD_SETS = "fieldSets";
    private static final String ID_COLLECTIONS = "collections";
    private final BSCol bsCol;
    private boolean visible = false;

    public Col(String id, UiObjectWkt objectModel, BSCol bsCol) {
        super(id, objectModel);
        this.bsCol = bsCol;
        this.buildGui();
    }

    private void buildGui() {
        ArrayList rows;
        String actionIdToHide;
        String actionIdToUse;
        WebMarkupContainer actionOwner;
        this.setRenderBodyOnly(true);
        if (this.bsCol.getSpan() == 0) {
            WktComponents.permanentlyHide((MarkupContainer)this, ID_COL);
            return;
        }
        WebMarkupContainer div = new WebMarkupContainer(ID_COL);
        Wkt.cssAppend(div, this.bsCol.toCssClass());
        DomainObjectLayoutData domainObject = this.bsCol.getDomainObject();
        if (domainObject != null) {
            WebMarkupContainer entityHeaderPanel = new WebMarkupContainer(ID_OBJECT_HEADER_PANEL);
            div.add(new Component[]{entityHeaderPanel});
            ComponentFactory componentFactory = this.getComponentFactoryRegistry().findComponentFactory(UiComponentType.OBJECT_ICON_TITLE_AND_COPYLINK, (IModel<?>)this.getModel());
            Component component = componentFactory.createComponent((IModel<?>)this.getModel());
            entityHeaderPanel.addOrReplace(new Component[]{component});
            actionOwner = entityHeaderPanel;
            actionIdToUse = "objectActions";
            actionIdToHide = "actions";
            this.visible = true;
        } else {
            WktComponents.permanentlyHide((MarkupContainer)div, ID_OBJECT_HEADER_PANEL);
            actionOwner = div;
            actionIdToUse = "actions";
            actionIdToHide = null;
        }
        List actionLayoutDataList = this.bsCol.getActions();
        Can visibleActions = (Can)_NullSafe.stream((Collection)actionLayoutDataList).filter(actionLayoutData -> actionLayoutData.getMetadataError() == null).filter(_NullSafe::isPresent).map(actionLayoutData -> ((UiObjectWkt)this.getModel()).getTypeOfSpecification().getAction(actionLayoutData.getId()).orElse(null)).filter(_NullSafe::isPresent).map(act -> ActionModel.forEntity((ObjectAction)act, (UiObjectWkt)((UiObjectWkt)this.getModel()))).collect(Can.toCan());
        if (!visibleActions.isEmpty()) {
            ActionLinksPanel.addActionLinks((MarkupContainer)actionOwner, actionIdToUse, (Can<ActionModel>)visibleActions, ActionLinksPanel.Style.INLINE_LIST);
            this.visible = true;
        } else {
            WktComponents.permanentlyHide((MarkupContainer)actionOwner, actionIdToUse);
        }
        if (actionIdToHide != null) {
            WktComponents.permanentlyHide((MarkupContainer)div, actionIdToHide);
        }
        if (!(rows = _Lists.newArrayList((Collection)this.bsCol.getRows())).isEmpty()) {
            RepeatingViewWithDynamicallyVisibleContent rowsRv = this.buildRows(ID_ROWS, rows);
            div.add(new Component[]{rowsRv});
            this.visible = this.visible || rowsRv.isVisible();
        } else {
            WktComponents.permanentlyHide((MarkupContainer)div, ID_ROWS);
        }
        List tabGroupsWithNonEmptyTabs = _NullSafe.stream((Collection)this.bsCol.getTabGroups()).filter(_NullSafe::isPresent).filter(bsTabGroup -> _NullSafe.stream((Collection)bsTabGroup.getTabs()).anyMatch(BSTab.Predicates.notEmpty())).collect(Collectors.toList());
        if (!tabGroupsWithNonEmptyTabs.isEmpty()) {
            RepeatingViewWithDynamicallyVisibleContent tabGroupRv = new RepeatingViewWithDynamicallyVisibleContent(ID_TAB_GROUPS);
            block4: for (Object bsTabGroup2 : tabGroupsWithNonEmptyTabs) {
                String id2 = tabGroupRv.newChildId();
                List tabs = _NullSafe.stream((Collection)bsTabGroup2.getTabs()).filter(BSTab.Predicates.notEmpty()).collect(Collectors.toList());
                switch (tabs.size()) {
                    case 0: {
                        throw new IllegalStateException("Cannot render tabGroup with no tabs");
                    }
                    case 1: {
                        if (bsTabGroup2.isCollapseIfOne() != null && !bsTabGroup2.isCollapseIfOne().booleanValue()) break;
                        BSTab bsTab = (BSTab)tabs.get(0);
                        List tabRows = bsTab.getRows();
                        RepeatingViewWithDynamicallyVisibleContent rowsRv = this.buildRows(id2, tabRows);
                        tabGroupRv.add(new Component[]{rowsRv});
                        continue block4;
                    }
                }
                TabGroupPanel tabGroup = new TabGroupPanel(id2, (UiObjectWkt)this.getModel(), (BSTabGroup)bsTabGroup2);
                tabGroupRv.add(new Component[]{tabGroup});
            }
            div.add(new Component[]{tabGroupRv});
            this.visible = this.visible || tabGroupRv.isVisible();
        } else {
            WktComponents.permanentlyHide((MarkupContainer)div, ID_TAB_GROUPS);
        }
        List fieldSetsWithProperties = _NullSafe.stream((Collection)this.bsCol.getFieldSets()).filter(_NullSafe::isPresent).filter(fieldSet -> !_NullSafe.isEmpty((Collection)fieldSet.getProperties())).collect(Collectors.toList());
        if (!fieldSetsWithProperties.isEmpty()) {
            RepeatingViewWithDynamicallyVisibleContent fieldSetRv = new RepeatingViewWithDynamicallyVisibleContent(ID_FIELD_SETS);
            for (FieldSet fieldSet2 : fieldSetsWithProperties) {
                String id3 = fieldSetRv.newChildId();
                PropertyGroup propertyGroup = new PropertyGroup(id3, (UiObjectWkt)this.getModel(), fieldSet2);
                fieldSetRv.add(new Component[]{propertyGroup});
            }
            div.add(new Component[]{fieldSetRv});
            this.visible = this.visible || fieldSetRv.isVisible();
        } else {
            WktComponents.permanentlyHide((MarkupContainer)div, ID_FIELD_SETS);
        }
        UiObjectWkt objectModel = (UiObjectWkt)this.getModel();
        ObjectSpecification ownerSpec = objectModel.getManagedObject().getSpecification();
        LinkedHashMap<String, CollectionLayoutData> collectionLayoutById = new LinkedHashMap<String, CollectionLayoutData>();
        _NullSafe.stream((Collection)this.bsCol.getCollections()).filter(colLayoutData -> colLayoutData.getMetadataError() == null).filter(colLayoutData -> !ownerSpec.getCollection(colLayoutData.getId()).isEmpty()).forEach(colLayoutData -> collectionLayoutById.put(colLayoutData.getId(), (CollectionLayoutData)colLayoutData));
        if (!collectionLayoutById.isEmpty()) {
            RepeatingViewWithDynamicallyVisibleContent collectionRv = new RepeatingViewWithDynamicallyVisibleContent(ID_COLLECTIONS);
            collectionLayoutById.forEach((id, layout) -> {
                Model helperModel = Model.of((Serializable)new ParentedCollectionPanelFactory.CollectionOwnerAndLayout(objectModel, (CollectionLayoutData)layout));
                ComponentFactory componentFactory = this.getComponentFactoryRegistry().findComponentFactory(UiComponentType.PARENTED_COLLECTION, (IModel<?>)helperModel);
                Component collectionPanel = componentFactory.createComponent(collectionRv.newChildId(), (IModel<?>)helperModel);
                collectionRv.add(collectionPanel);
            });
            div.add(new Component[]{collectionRv});
            this.visible = this.visible || collectionRv.isVisible();
        } else {
            WktComponents.permanentlyHide((MarkupContainer)div, ID_COLLECTIONS);
        }
        Col panel = this;
        if (this.visible) {
            panel.add(new Component[]{div});
        } else {
            WktComponents.permanentlyHide((MarkupContainer)panel, div.getId());
        }
    }

    private RepeatingViewWithDynamicallyVisibleContent buildRows(String owningId, List<BSRow> rows) {
        RepeatingViewWithDynamicallyVisibleContent rowRv = new RepeatingViewWithDynamicallyVisibleContent(owningId);
        for (BSRow bsRow : rows) {
            String id = rowRv.newChildId();
            Row row = new Row(id, (UiObjectWkt)this.getModel(), bsRow);
            rowRv.add(new Component[]{row});
        }
        return rowRv;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }
}

