/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.pages.error;

import java.util.ArrayList;
import java.util.List;
import org.apache.causeway.applib.services.error.ErrorDetails;
import org.apache.causeway.applib.services.error.ErrorReportingService;
import org.apache.causeway.applib.services.error.Ticket;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.util.PageParameterUtils;
import org.apache.causeway.viewer.wicket.ui.errors.ExceptionModel;
import org.apache.causeway.viewer.wicket.ui.errors.ExceptionStackTracePanel;
import org.apache.causeway.viewer.wicket.ui.errors.StackTraceDetail;
import org.apache.causeway.viewer.wicket.ui.pages.PageAbstract;
import org.apache.causeway.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.wicket.Component;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;

@AuthorizeInstantiation(value={"org.apache.causeway.security.AUTHORIZED_USER_ROLE"})
public class ErrorPage
extends PageAbstract {
    private static final long serialVersionUID = 1L;
    private static final String ID_EXCEPTION_STACK_TRACE = "exceptionStackTrace";

    public ErrorPage(ExceptionModel exceptionModel) {
        super(PageParameterUtils.newPageParameters(), null, new UiComponentType[0]);
        this.addBookmarkedPages(this.themeDiv);
        ErrorReportingService errorReportingService = super.getMetaModelContext().getServiceRegistry().lookupService(ErrorReportingService.class).orElse(null);
        if (errorReportingService != null) {
            String mainMessage = exceptionModel.getMainMessage();
            boolean recognized = exceptionModel.isRecognized();
            boolean authorizationException = exceptionModel.isAuthorizationException();
            List<StackTraceDetail> stackTrace = exceptionModel.getStackTrace();
            List<String> stackDetailList = this.transform(stackTrace);
            List<List<StackTraceDetail>> stackTraces = exceptionModel.getStackTraces();
            ArrayList stackDetailLists = _Lists.newArrayList();
            for (List<StackTraceDetail> trace : stackTraces) {
                stackDetailLists.add(this.transform(trace));
            }
            ErrorDetails errorDetails = new ErrorDetails(mainMessage, recognized, authorizationException, stackDetailList, (List)stackDetailLists);
            Ticket ticket = errorReportingService.reportError(errorDetails);
            if (ticket != null) {
                exceptionModel.setTicket(ticket);
            }
        }
        PageClassRegistry pageClassRegistry = (PageClassRegistry)super.getServiceRegistry().lookupServiceElseFail(PageClassRegistry.class);
        this.themeDiv.add(new Component[]{new ExceptionStackTracePanel(pageClassRegistry, ID_EXCEPTION_STACK_TRACE, exceptionModel)});
    }

    protected List<String> transform(List<StackTraceDetail> stackTrace) {
        return _Lists.map(stackTrace, stackTraceDetail -> stackTraceDetail.getLine());
    }
}

