/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.pages.standalonecollection;

import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.publishing.spi.PageRenderSubscriber;
import org.apache.causeway.commons.binding.Observable;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.object.Bookmarkable;
import org.apache.causeway.core.metamodel.tabular.DataTableInteractive;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModelStandalone;
import org.apache.causeway.viewer.wicket.model.util.PageParameterUtils;
import org.apache.causeway.viewer.wicket.ui.pages.PageAbstract;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.model.IModel;

@AuthorizeInstantiation(value={"org.apache.causeway.security.AUTHORIZED_USER_ROLE"})
public class StandaloneCollectionPage
extends PageAbstract {
    private static final long serialVersionUID = 1L;
    private final CollectionModelStandalone collectionModel;

    public StandaloneCollectionPage(CollectionModelStandalone collectionModel) {
        super(PageParameterUtils.newPageParameters(), collectionModel.getName(), UiComponentType.STANDALONE_COLLECTION);
        this.collectionModel = collectionModel;
        this.addChildComponents(this.themeDiv, (IModel<?>)collectionModel);
        this.addBookmarkedPages(this.themeDiv);
    }

    @Override
    public void onRendering(Can<PageRenderSubscriber> objectRenderSubscribers) {
        this.onRenderingOrRendered(objectRenderSubscribers, (pageRenderSubscriber, bookmarkListSupplier) -> {
            pageRenderSubscriber.onRenderingCollection(bookmarkListSupplier);
            return null;
        });
    }

    @Override
    public void onRendered(Can<PageRenderSubscriber> objectRenderSubscribers) {
        this.onRenderingOrRendered(objectRenderSubscribers, (pageRenderSubscriber, bookmarkListSupplier) -> {
            pageRenderSubscriber.onRenderedCollection(bookmarkListSupplier);
            return null;
        });
    }

    private void onRenderingOrRendered(Can<PageRenderSubscriber> objectRenderSubscribers, BiFunction<PageRenderSubscriber, Supplier<List<Bookmark>>, Void> handler) {
        if (objectRenderSubscribers.isEmpty()) {
            return;
        }
        Supplier<List> listSupplier = () -> {
            DataTableInteractive dataTableInteractive = (DataTableInteractive)this.collectionModel.getObject();
            Observable dataElements = dataTableInteractive.dataElementsObservable();
            Can managedObjects = (Can)dataElements.getValue();
            List bookmarks = managedObjects.stream().map(Bookmarkable::getBookmark).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toUnmodifiableList());
            return bookmarks;
        };
        objectRenderSubscribers.forEach(subscriber -> handler.apply((PageRenderSubscriber)subscriber, (Supplier<List<Bookmark>>)listSupplier));
    }
}

