/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.panels;

import java.io.Serializable;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.applib.services.exceprecog.Category;
import org.apache.causeway.applib.services.exceprecog.ExceptionRecognizerService;
import org.apache.causeway.applib.services.exceprecog.Recognition;
import org.apache.causeway.commons.functional.Either;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.model.models.FormExecutor;
import org.apache.causeway.viewer.wicket.model.models.FormExecutorContext;
import org.apache.causeway.viewer.wicket.model.models.HasCommonContext;
import org.apache.causeway.viewer.wicket.model.models.ParameterModel;
import org.apache.causeway.viewer.wicket.model.models.PropertyModel;
import org.apache.causeway.viewer.wicket.ui.actionresponse.ActionResultResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.Form;
import org.springframework.lang.Nullable;

public final class FormExecutorDefault
implements FormExecutor,
HasCommonContext {
    @Generated
    private static final Logger log = LogManager.getLogger(FormExecutorDefault.class);
    private static final long serialVersionUID = 1L;
    private final Either<ActionModel, PropertyModel> actionOrPropertyModel;

    public static FormExecutor forAction(ActionModel actionModel) {
        return new FormExecutorDefault((Either<ActionModel, PropertyModel>)Either.left((Object)actionModel));
    }

    public static FormExecutor forProperty(PropertyModel propertyModel) {
        return new FormExecutorDefault((Either<ActionModel, PropertyModel>)Either.right((Object)propertyModel));
    }

    public static FormExecutor forMember(Either<ActionModel, PropertyModel> actionOrPropertyModel) {
        return new FormExecutorDefault(actionOrPropertyModel);
    }

    private FormExecutorDefault(Either<ActionModel, PropertyModel> actionOrPropertyModel) {
        this.actionOrPropertyModel = actionOrPropertyModel;
    }

    public FormExecutor.FormExecutionOutcome executeAndProcessResults(AjaxRequestTarget ajaxTarget, Form<?> feedbackFormIfAny, FormExecutorContext formExecutorContext) {
        try {
            Optional invalidReasonIfAny = Recognition.of((Category)Category.CONSTRAINT_VIOLATION, (String)((String)this.actionOrPropertyModel.fold(act -> act.getValidityConsent().getReasonAsString().orElse(null), prop -> prop.getReasonInvalidIfAny())));
            if (invalidReasonIfAny.isPresent()) {
                this.raiseErrorMessage(ajaxTarget, feedbackFormIfAny, (Recognition)invalidReasonIfAny.get());
                return FormExecutor.FormExecutionOutcome.FAILURE_RECOVERABLE_SO_STAY_ON_PAGE;
            }
            ManagedObject resultAdapter = (ManagedObject)this.actionOrPropertyModel.fold(act -> act.executeActionAndReturnResult(), prop -> prop.applyValueThenReturnOwner());
            if (formExecutorContext.getAssociatedParameter().isPresent()) {
                ((ParameterModel)formExecutorContext.getAssociatedParameter().get()).setValue(resultAdapter);
                return FormExecutor.FormExecutionOutcome.SUCCESS_IN_NESTED_CONTEXT_SO_STAY_ON_PAGE;
            }
            ActionResultResponse resultResponse = (ActionResultResponse)this.actionOrPropertyModel.fold(act -> ActionResultResponse.determineAndInterpretResult(act, ajaxTarget, resultAdapter), prop -> ActionResultResponse.toDomainObjectPage(resultAdapter));
            resultResponse.handlingStrategy().handleResults(resultResponse);
            return FormExecutor.FormExecutionOutcome.SUCCESS_AND_REDIRECED_TO_RESULT_PAGE;
        }
        catch (Throwable ex) {
            if (!formExecutorContext.isWithinInlinePrompt() && this.recognizeExceptionThenRaise(ex, ajaxTarget, feedbackFormIfAny).isPresent()) {
                return FormExecutor.FormExecutionOutcome.FAILURE_RECOVERABLE_SO_STAY_ON_PAGE;
            }
            throw ex;
        }
    }

    private Optional<Recognition> recognizeExceptionThenRaise(Throwable ex, AjaxRequestTarget target, Form<?> feedbackForm) {
        Optional recognition = this.getExceptionRecognizerService().recognize(ex);
        recognition.ifPresent(recog -> this.raiseErrorMessage(target, feedbackForm, (Recognition)recog));
        return recognition;
    }

    private void raiseErrorMessage(@Nullable AjaxRequestTarget targetIfAny, @Nullable Form<?> feedbackFormIfAny, @NonNull Recognition recognition) {
        String errorMsg;
        if (recognition == null) {
            throw new NullPointerException("recognition is marked non-null but is null");
        }
        String string = errorMsg = recognition.getCategory().isSuppressCategoryInUI() ? recognition.toMessageNoCategory(this.getTranslationService()) : recognition.toMessage(this.getTranslationService());
        if (targetIfAny != null && feedbackFormIfAny != null) {
            targetIfAny.add(new Component[]{feedbackFormIfAny});
            feedbackFormIfAny.error((Serializable)((Object)errorMsg));
        } else {
            this.getMessageService().setError(errorMsg);
        }
    }

    private ExceptionRecognizerService getExceptionRecognizerService() {
        return (ExceptionRecognizerService)this.getServiceRegistry().lookupServiceElseFail(ExceptionRecognizerService.class);
    }
}

