/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.table;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.causeway.applib.services.i18n.TranslationContext;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.primitives._Longs;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.tabular.DataTableInteractive;
import org.apache.causeway.viewer.wicket.model.hints.UiHintContainer;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.model.tableoption.PagesizeChoice;
import org.apache.causeway.viewer.wicket.model.tableoption.SelectOperationChoice;
import org.apache.causeway.viewer.wicket.model.tableoption.SelectOperationChoiceKey;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.CollectionContentsSortableDataProvider;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns.ToggleboxColumn;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LambdaModel;
import org.danekja.java.util.function.serializable.SerializableSupplier;

public abstract class DataTableWithPagesAndFilter<T, S>
extends DataTable<T, S> {
    private static final long serialVersionUID = 1L;
    private static final String UIHINT_PAGE_NUMBER = "pageNumber";
    private static final String UIHINT_PAGE_SIZE = "pageSize";
    private static final String UIHINT_SEARCH_ARG = "searchArg";
    protected String searchArg;

    protected DataTableWithPagesAndFilter(String id, List<? extends IColumn<T, S>> columns, ISortableDataProvider<T, S> dataProvider, int rowsPerPage) {
        super(id, columns, dataProvider, (long)rowsPerPage);
        this.setOutputMarkupId(true);
        this.setVersioned(false);
    }

    public final void setSortOrderHintAndBroadcast(SortOrder order, String property, AjaxRequestTarget target) {
        UiHintContainer uiHintContainer = this.getUiHintContainer();
        if (uiHintContainer == null) {
            return;
        }
        for (SortOrder eachSortOrder : SortOrder.values()) {
            uiHintContainer.clearHint((Component)this, eachSortOrder.name());
        }
        uiHintContainer.setHint((Component)this, order.name(), property);
    }

    public final void setPageSizeHintAndBroadcast(AjaxRequestTarget target) {
        UiHintContainer uiHintContainer = this.getUiHintContainer();
        if (uiHintContainer == null) {
            return;
        }
        uiHintContainer.setHint((Component)this, UIHINT_PAGE_SIZE, "" + this.getItemsPerPage());
    }

    public final void setPageNumberHintAndBroadcast(AjaxRequestTarget target) {
        UiHintContainer uiHintContainer = this.getUiHintContainer();
        if (uiHintContainer == null) {
            return;
        }
        uiHintContainer.setHint((Component)this, UIHINT_PAGE_NUMBER, "" + this.getCurrentPage());
    }

    public final void setSearchHintAndBroadcast(AjaxRequestTarget target) {
        UiHintContainer uiHintContainer = this.getUiHintContainer();
        if (uiHintContainer == null) {
            return;
        }
        uiHintContainer.setHint((Component)this, UIHINT_SEARCH_ARG, this.searchArg);
    }

    protected void onConfigure() {
        super.onConfigure();
        this.honorSearchArgHint();
        this.honorPageSizeHint();
        this.honorPageNumberHint();
    }

    public DataTableInteractive tableModel() {
        DataTableInteractive dataTableInteractive;
        IDataProvider iDataProvider = this.getDataProvider();
        if (iDataProvider instanceof CollectionContentsSortableDataProvider) {
            CollectionContentsSortableDataProvider dataProvider = (CollectionContentsSortableDataProvider)iDataProvider;
            dataTableInteractive = dataProvider.getDataTableModel();
        } else {
            dataTableInteractive = null;
        }
        DataTableInteractive dataTableInteractive2 = dataTableInteractive;
        Objects.requireNonNull(dataTableInteractive2, () -> "could not resolve the underlying model for this table component due to an unexpected DataProvider type %s".formatted(Optional.ofNullable(this.getDataProvider()).map(Object::getClass).map(Class::getName).orElse("null")));
        return dataTableInteractive2;
    }

    public int elementCount() {
        return ((Can)this.tableModel().dataElementsObservable().getValue()).size();
    }

    public boolean isRowSelectionEnabled() {
        return Can.ofCollection((Collection)this.getColumns()).getFirst().map(col -> col instanceof ToggleboxColumn).orElse(false);
    }

    public void setSearchArg(String value) {
        if (_Strings.nullToEmpty((String)this.searchArg).equals(_Strings.nullToEmpty((String)value))) {
            return;
        }
        this.searchArg = value;
        this.tableModel().searchArgumentBindable().setValue((Object)this.searchArg);
    }

    public IModel<String> getEntriesPerPageAsLiteral() {
        return LambdaModel.of((SerializableSupplier & Serializable)() -> String.format("%s", this.getItemsPerPage() <= 1000L ? "" + this.getItemsPerPage() : "All"));
    }

    public List<PagesizeChoice> getPagesizeChoices() {
        List<PagesizeChoice> choices = List.of(new PagesizeChoice(this.translate("All"), Long.MAX_VALUE), new PagesizeChoice("1000", 1000L), new PagesizeChoice("100", 100L), new PagesizeChoice("25", 25L), new PagesizeChoice("12", 12L));
        return choices;
    }

    public List<SelectOperationChoice> getSelectOperationChoices() {
        return this.isRowSelectionEnabled() ? Stream.of(SelectOperationChoiceKey.values()).filter(SelectOperationChoiceKey.isAvailableWhen((boolean)this.isPaged())).map(key -> new SelectOperationChoice(key, this.translate(key.englishTitle))).toList() : Collections.emptyList();
    }

    public void executeSelectOperation(SelectOperationChoice selectOperationChoice) {
        switch (selectOperationChoice.key()) {
            case SEL_ALL: {
                this.tableModel().selectAllFiltered(true);
                break;
            }
            case CLEAR: {
                this.tableModel().selectAll(false);
                break;
            }
            case PAGE_SEL: {
                this.tableModel().selectRangeOfRowsByIndex(this.getCurrentPageRowIndexes(), true);
                break;
            }
            case PAGE_UNSEL: {
                this.tableModel().selectRangeOfRowsByIndex(this.getCurrentPageRowIndexes(), false);
            }
        }
    }

    public boolean isPaged() {
        return this.getPageCount() > 1L;
    }

    public IntStream getCurrentPageRowIndexes() {
        int pageIndex = Math.toIntExact(this.getCurrentPage());
        int pageSize = Math.toIntExact(this.getItemsPerPage());
        int fromRowIndexInclusive = Math.toIntExact(pageIndex * pageSize);
        int toRowIndexExclusive = Math.toIntExact(fromRowIndexInclusive + pageSize);
        return IntStream.range(fromRowIndexInclusive, toRowIndexExclusive);
    }

    public final Optional<PagesizeChoice> getCurrentPagesizeChoice() {
        return this.getPagesizeChoices().stream().filter(c -> c.itemsPerPage() == this.getItemsPerPage()).findFirst();
    }

    private void honorPageSizeHint() {
        UiHintContainer uiHintContainer = this.getUiHintContainer();
        if (uiHintContainer == null) {
            return;
        }
        this.parsePageSize(uiHintContainer.getHint((Component)this, UIHINT_PAGE_SIZE)).ifPresent(arg_0 -> ((DataTableWithPagesAndFilter)this).setItemsPerPage(arg_0));
    }

    private void honorPageNumberHint() {
        UiHintContainer uiHintContainer = this.getUiHintContainer();
        if (uiHintContainer == null) {
            return;
        }
        this.parseZeroBasedPageNr(uiHintContainer.getHint((Component)this, UIHINT_PAGE_NUMBER)).ifPresent(arg_0 -> ((DataTableWithPagesAndFilter)this).setCurrentPage(arg_0));
    }

    private void honorSearchArgHint() {
        UiHintContainer uiHintContainer = this.getUiHintContainer();
        if (uiHintContainer == null) {
            return;
        }
        this.setSearchArg(uiHintContainer.getHint((Component)this, UIHINT_SEARCH_ARG));
    }

    private UiHintContainer getUiHintContainer() {
        return UiHintContainer.Util.hintContainerOf((Component)this, UiObjectWkt.class);
    }

    private OptionalLong parsePageSize(String string) {
        long pageSize = _Longs.parseLong((String)string, (int)10).orElse(-1L);
        return pageSize >= 1L ? OptionalLong.of(pageSize) : OptionalLong.empty();
    }

    private OptionalLong parseZeroBasedPageNr(String string) {
        long zeroBasedPageNr = _Longs.parseLong((String)string, (int)10).orElse(-1L);
        return zeroBasedPageNr >= 0L ? OptionalLong.of(zeroBasedPageNr) : OptionalLong.empty();
    }

    private String translate(String text) {
        return MetaModelContext.translationServiceOrFallback().translate(TranslationContext.named((String)"Table"), text);
    }
}

