/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.widgets.actionlink;

import java.io.Serializable;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.debug._Probe;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.context.HasMetaModelContext;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedAction;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.viewer.commons.model.action.HasManagedAction;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.links.Menuable;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.model.models.ActionPrompt;
import org.apache.causeway.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.causeway.viewer.wicket.model.models.ActionPromptWithExtraContent;
import org.apache.causeway.viewer.wicket.model.models.FormExecutor;
import org.apache.causeway.viewer.wicket.model.models.FormExecutorContext;
import org.apache.causeway.viewer.wicket.model.models.InlinePromptContext;
import org.apache.causeway.viewer.wicket.model.util.PageParameterUtils;
import org.apache.causeway.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.causeway.viewer.wicket.ui.app.registry.HasComponentFactoryRegistry;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributeFragmentFactory;
import org.apache.causeway.viewer.wicket.ui.components.layout.bs.BSGridPanelFactory;
import org.apache.causeway.viewer.wicket.ui.exec.FormExecutorDefault;
import org.apache.causeway.viewer.wicket.ui.pages.obj.DomainObjectPage;
import org.apache.causeway.viewer.wicket.ui.panels.PanelUtil;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.AjaxIndicatorAppender;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.jspecify.annotations.NonNull;

public final class ActionLink
extends IndicatingAjaxLink<ManagedObject>
implements HasMetaModelContext,
Menuable,
HasManagedAction {
    private static final long serialVersionUID = 1L;
    private static final String ID_ACTION_LINK = "actionLink";
    private final AjaxIndicatorAppender indicatorAppenderIfAny;

    public static ActionLink create(@NonNull ActionModel actionModel) {
        ActionLink actionLink = new ActionLink(ID_ACTION_LINK, actionModel);
        return Wkt.cssAppend(actionLink, "noVeil");
    }

    private ActionLink(String id, ActionModel model) {
        super(id, (IModel)model);
        _Assert.assertNotNull((Object)model.getAction(), (String)"ActionLink requires an Action");
        AjaxIndicatorAppender ajaxIndicatorAppender = this.indicatorAppenderIfAny = this.getSettings().isUseIndicatorForNoArgAction() ? new AjaxIndicatorAppender() : null;
        if (this.indicatorAppenderIfAny != null) {
            this.add(new Behavior[]{this.indicatorAppenderIfAny});
        }
    }

    public ActionModel getActionModel() {
        return (ActionModel)this.getModel();
    }

    public ManagedAction getManagedAction() {
        return this.getActionModel().getManagedAction();
    }

    public ObjectAction getAction() {
        return this.getActionModel().getAction();
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        if (this.getSettings().isPreventDoubleClickForNoArgAction()) {
            PanelUtil.disableBeforeReenableOnComplete(attributes, (Component)this);
        }
        attributes.setEventPropagation(AjaxRequestAttributes.EventPropagation.BUBBLE);
    }

    public String getReasonDisabledIfAny() {
        return this.isVisible() ? (String)this.getActionModel().getUsabilityConsent().getReasonAsString().orElse(null) : null;
    }

    public boolean isVisible() {
        return this.getActionModel().getVisibilityConsent().isAllowed();
    }

    public boolean isEnabled() {
        return this.getActionModel().getUsabilityConsent().isAllowed();
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        Wkt.fixDisabledState((Component)this, tag);
    }

    public String getAjaxIndicatorMarkupId() {
        return this.indicatorAppenderIfAny != null ? this.indicatorAppenderIfAny.getMarkupId() : null;
    }

    public void onClick(AjaxRequestTarget ajaxTarget) {
        _Probe.entryPoint((_Probe.EntryPoint)_Probe.EntryPoint.USER_INTERACTION, (String)"Wicket Ajax Request, originating from User clicking an Action Link.");
        ActionModel actionModel = this.getActionModel();
        if (actionModel.getPromptStyle().isDialogAny() || actionModel.getInlinePromptContext() == null) {
            if (actionModel.hasParameters()) {
                this.startDialogWithParams(ajaxTarget);
            } else {
                this.executeWithoutParams();
            }
        } else {
            this.startDialogInline(ajaxTarget);
        }
    }

    private void executeWithoutParams() {
        ActionModel actionModel = this.getActionModel();
        FormExecutor.FormExecutionOutcome outcome = FormExecutorDefault.forAction(actionModel).executeAndProcessResults(null, null, (FormExecutorContext)actionModel);
        if (outcome.isFailure()) {
            ManagedObject targetAdapter = actionModel.getParentObject();
            Bookmark bookmark = (Bookmark)targetAdapter.refreshBookmark().orElseThrow();
            this.getTransactionService().flushTransaction();
            RequestCycle.get().setResponsePage(DomainObjectPage.class, PageParameterUtils.createPageParametersForBookmark((Bookmark)bookmark));
        }
    }

    private void startDialogWithParams(AjaxRequestTarget target) {
        ActionModel actionModel = this.getActionModel();
        ObjectSpecification actionOwnerSpec = actionModel.getActionOwner().objSpec();
        ActionPrompt actionPrompt = ActionPromptProvider.getFrom((Page)this.getPage()).getActionPrompt(actionModel.getPromptStyle(), actionOwnerSpec.getBeanSort());
        Component actionParametersPanel = this.getComponentFactoryRegistry().createComponent(actionPrompt.getContentId(), UiComponentType.ACTION_PROMPT, (IModel<?>)actionModel);
        Label label = Wkt.label(actionPrompt.getTitleId(), (IModel<String>)((IModel & Serializable)() -> ((ActionModel)actionModel).getFriendlyName()));
        actionPrompt.setTitle((Component)label, target);
        actionPrompt.setPanel(actionParametersPanel, target);
        actionPrompt.showPrompt(target);
        _Casts.castTo(ActionPromptWithExtraContent.class, (Object)actionPrompt).ifPresent(promptWithExtraContent -> BSGridPanelFactory.extraContentForMixin(promptWithExtraContent.getExtraContentId(), actionModel).ifPresent(gridPanel -> promptWithExtraContent.setExtraContentPanel(gridPanel, target)));
    }

    private void startDialogInline(AjaxRequestTarget target) {
        ActionModel actionModel = this.getActionModel();
        InlinePromptContext inlinePromptContext = actionModel.getInlinePromptContext();
        MarkupContainer scalarTypeContainer = inlinePromptContext.scalarTypeContainer();
        this.getComponentFactoryRegistry().addOrReplaceComponent(scalarTypeContainer, AttributeFragmentFactory.FrameFragment.INLINE_PROMPT_FORM.getContainerId(), UiComponentType.PARAMETERS, (IModel<?>)actionModel);
        inlinePromptContext.onPrompt();
        Wkt.javaScriptAdd(target, Wkt.EventTopic.FOCUS_FIRST_PARAMETER, scalarTypeContainer.getMarkupId());
        target.add(new Component[]{scalarTypeContainer});
    }

    private ComponentFactoryRegistry getComponentFactoryRegistry() {
        return ((HasComponentFactoryRegistry)Application.get()).getComponentFactoryRegistry();
    }

    public CausewayConfiguration.Viewer.Wicket getSettings() {
        return this.getMetaModelContext().getConfiguration().getViewer().getWicket();
    }

    public Menuable.Kind menuableKind() {
        return Menuable.Kind.LINK;
    }
}

