/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.actionlinks.serviceactions;

import java.io.Serializable;
import java.util.List;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.collections.ImmutableCollection;
import org.apache.causeway.viewer.wicket.ui.components.actionlinks.serviceactions.CssMenuItem;
import org.apache.causeway.viewer.wicket.ui.components.actionlinks.serviceactions.ServiceActionUtil;
import org.apache.causeway.viewer.wicket.ui.panels.PanelBase;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.danekja.java.util.function.serializable.SerializableConsumer;

abstract class MenuActionPanel
extends PanelBase {
    private static final long serialVersionUID = 1L;

    public MenuActionPanel(String id) {
        super(id);
    }

    protected ListView<CssMenuItem> subMenuItemsView(Can<CssMenuItem> subMenuItems) {
        return Wkt.listView("subMenuItems", subMenuItems.toList(), (SerializableConsumer & Serializable)listItem -> {
            CssMenuItem subMenuItem = (CssMenuItem)listItem.getModelObject();
            switch (subMenuItem.menuableKind()) {
                case SECTION_SEPARATOR: {
                    this.addSpacer(subMenuItem, (ListItem<CssMenuItem>)listItem);
                    return;
                }
                case SECTION_LABEL: {
                    this.addSectionLabel(subMenuItem, (ListItem<CssMenuItem>)listItem);
                    return;
                }
            }
            if (subMenuItem.hasSubMenuItems()) {
                this.addFolderItem(subMenuItem, (ListItem<CssMenuItem>)listItem);
            } else {
                this.addLeafItem(subMenuItem, (ListItem<CssMenuItem>)listItem);
            }
        });
    }

    protected Can<CssMenuItem> flatten(List<CssMenuItem> menuItems) {
        return (Can)menuItems.stream().map(CssMenuItem::getSubMenuItems).flatMap(ImmutableCollection::stream).collect(Can.toCan());
    }

    private void addFolderItem(CssMenuItem menuItem, ListItem<CssMenuItem> listItem) {
        MenuActionPanel parent = this;
        ServiceActionUtil.addFolderItem(menuItem, listItem, (MarkupContainer)parent);
    }

    private void addLeafItem(CssMenuItem menuItem, ListItem<CssMenuItem> listItem) {
        MenuActionPanel parent = this;
        ServiceActionUtil.addLeafItem(menuItem, listItem, (MarkupContainer)parent);
    }

    private void addSpacer(CssMenuItem menuItem, ListItem<CssMenuItem> listItem) {
        MenuActionPanel parent = this;
        Fragment fragment = new Fragment("content", "separatorItem", (MarkupContainer)parent);
        listItem.add(new Component[]{fragment});
        Wkt.cssAppend(listItem, "list-separator");
    }

    private void addSectionLabel(CssMenuItem menuItem, ListItem<CssMenuItem> listItem) {
        MenuActionPanel parent = this;
        Fragment fragment = new Fragment("content", "sectionItem", (MarkupContainer)parent);
        Wkt.labelAdd((MarkupContainer)fragment, "sectionLabel", menuItem.getName());
        listItem.add(new Component[]{fragment});
        Wkt.cssAppend(listItem, "list-section-label");
    }
}

