/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.attributes.markup;

import java.io.Serializable;
import java.util.Optional;
import org.apache.causeway.applib.value.semantics.Renderer;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.MmValueUtils;
import org.apache.causeway.core.metamodel.spec.feature.ObjectFeature;
import org.apache.causeway.viewer.commons.model.attrib.UiParameter;
import org.apache.causeway.viewer.wicket.model.models.PropertyModel;
import org.apache.causeway.viewer.wicket.model.models.ValueModel;
import org.apache.causeway.viewer.wicket.ui.components.attributes.markup.HighlightBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.model.IModel;
import org.jspecify.annotations.Nullable;
import org.springframework.util.StringUtils;

public class MarkupComponent
extends WebComponent {
    private static final long serialVersionUID = 1L;
    private final Options options;

    public MarkupComponent(String id, IModel<?> model, @Nullable Options options) {
        super(id, model);
        this.options = options == null ? Options.defaults() : options;
    }

    public MarkupComponent(String id, IModel<?> model) {
        this(id, model, null);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        this.highlightBehavior().ifPresent(highlighter -> highlighter.renderHead(response));
    }

    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        this.htmlContent().ifPresentOrElse(html -> this.replaceComponentTagBody(markupStream, openTag, this.highlightBehavior().map(highlighter -> highlighter.htmlContentPostProcess((String)html)).orElse((String)html)), () -> this.replaceComponentTagBody(markupStream, openTag, ""));
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.setType(XmlTag.TagType.OPEN);
    }

    private Optional<HighlightBehavior> highlightBehavior() {
        return HighlightBehavior.lookup(this.options.syntaxHighlighter());
    }

    protected Optional<String> htmlContent() {
        Object modelObject = this.getDefaultModelObject();
        if (modelObject == null) {
            return Optional.empty();
        }
        if (modelObject instanceof ManagedObject) {
            ManagedObject managedObj = (ManagedObject)modelObject;
            ObjectFeature feature = this.lookupObjectFeatureIn().orElse(null);
            String asHtml = MmValueUtils.htmlStringForValueType((ObjectFeature)feature, (ManagedObject)managedObj);
            return StringUtils.hasLength((String)asHtml) ? Optional.of(asHtml) : Optional.empty();
        }
        return Optional.ofNullable(modelObject.toString());
    }

    protected Optional<ObjectFeature> lookupObjectFeatureIn() {
        IModel model = this.getDefaultModel();
        if (model instanceof PropertyModel) {
            PropertyModel propertyModel = (PropertyModel)model;
            return Optional.of(propertyModel.getMetaModel());
        }
        if (model instanceof UiParameter) {
            UiParameter uiParameter = (UiParameter)model;
            return Optional.of(uiParameter.getMetaModel());
        }
        if (model instanceof ValueModel) {
            ValueModel valueModel = (ValueModel)model;
            return Optional.of(valueModel.objectMember());
        }
        return Optional.empty();
    }

    public record Options(Renderer.SyntaxHighlighter syntaxHighlighter) implements Serializable
    {
        public static Options defaults() {
            return new Options(Renderer.SyntaxHighlighter.NONE);
        }
    }
}

