/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collection;

import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import lombok.Generated;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.causeway.core.metamodel.tabular.DataTableInteractive;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModelParented;
import org.apache.causeway.viewer.wicket.ui.components.collection.selector.CollectionPresentationSelectorPanel;
import org.apache.causeway.viewer.wicket.ui.components.collection.selector.CollectionPresentationSelectorProvider;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.feedback.ComponentFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.model.IModel;

public class CollectionPanel
extends PanelAbstract<DataTableInteractive, CollectionModelParented>
implements CollectionPresentationSelectorProvider {
    private static final long serialVersionUID = 1L;
    private static final String ID_FEEDBACK = "feedback";
    private CollectionPresentationSelectorPanel selectorDropdownPanel;

    public CollectionPanel(String id, CollectionModelParented collectionModel) {
        super(id, collectionModel);
        OneToManyAssociation collMetaModel = ((CollectionModelParented)this.getModel()).getMetaModel();
        Can associatedActions = (Can)collMetaModel.streamAssociatedActions().map(act -> ActionModel.forCollection((ObjectAction)act, (CollectionModelParented)collectionModel)).collect(Can.toCan());
        collectionModel.setLinkAndLabels((Iterable)associatedActions);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.buildGui();
    }

    private void buildGui() {
        Component collectionContents = this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)this, UiComponentType.COLLECTION_CONTENTS, (IModel<?>)this.getModel());
        this.addOrReplace(new Component[]{new NotificationPanel(ID_FEEDBACK, collectionContents, (IFeedbackMessageFilter)new ComponentFeedbackMessageFilter(collectionContents))});
        this.setOutputMarkupId(true);
    }

    @Override
    @Generated
    public CollectionPresentationSelectorPanel getSelectorDropdownPanel() {
        return this.selectorDropdownPanel;
    }

    @Generated
    public void setSelectorDropdownPanel(CollectionPresentationSelectorPanel selectorDropdownPanel) {
        this.selectorDropdownPanel = selectorDropdownPanel;
    }
}

