/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns;

import java.io.Serializable;
import org.apache.causeway.core.metamodel.context.HasMetaModelContext;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.tabular.DataRow;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.coll.DataRowWkt;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.causeway.viewer.wicket.ui.app.registry.HasComponentFactoryRegistry;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns.ActionColumn;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns.GenericColumn;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns.TitleColumn;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns.ToggleboxColumn;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class GenericColumnAbstract
extends AbstractColumn<DataRow, String>
implements GenericColumn,
HasMetaModelContext {
    private static final long serialVersionUID = 1L;
    private transient ComponentFactoryRegistry componentRegistry;
    private final Class<?> elementClass;
    private transient ObjectSpecification elementType;

    protected GenericColumnAbstract(ObjectSpecification elementType, String columnName) {
        this(elementType, (IModel<String>)Model.of((Serializable)((Object)columnName)), null);
    }

    protected GenericColumnAbstract(ObjectSpecification elementType, IModel<String> columnNameModel, String sortColumn) {
        super(columnNameModel, (Object)sortColumn);
        this.elementType = elementType;
        this.elementClass = elementType.getCorrespondingClass();
    }

    public final void populateItem(Item<ICellPopulator<DataRow>> cellItem, String componentId, IModel<DataRow> rowModel) {
        cellItem.add(new Component[]{this.createCellComponent(componentId, (DataRowWkt)rowModel)});
        if (this instanceof ActionColumn) {
            Wkt.cssAppend(cellItem, "action-column");
        } else if (this instanceof TitleColumn) {
            Wkt.cssAppend(cellItem, "title-column");
            if (((TitleColumn)this).isTitleSuppressed()) {
                Wkt.cssAppend(cellItem, "title-suppressed");
            }
        } else if (this instanceof ToggleboxColumn) {
            Wkt.cssAppend(cellItem, "togglebox-column");
            MarkupContainer row = cellItem.getParent().getParent();
            row.setOutputMarkupId(true);
        }
    }

    protected abstract Component createCellComponent(String var1, DataRowWkt var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ObjectSpecification elementType() {
        GenericColumnAbstract genericColumnAbstract = this;
        synchronized (genericColumnAbstract) {
            if (this.elementType == null) {
                this.elementType = MetaModelContext.instanceElseFail().specForTypeElseFail(this.elementClass);
            }
        }
        return this.elementType;
    }

    protected ComponentFactory findComponentFactory(UiComponentType uiComponentType, IModel<?> model) {
        return this.getComponentRegistry().findComponentFactory(uiComponentType, model);
    }

    protected ComponentFactoryRegistry getComponentRegistry() {
        if (this.componentRegistry == null) {
            HasComponentFactoryRegistry componentFactoryRegistryAccessor = (HasComponentFactoryRegistry)Application.get();
            this.componentRegistry = componentFactoryRegistryAccessor.getComponentFactoryRegistry();
        }
        return this.componentRegistry;
    }
}

