/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collection.selector;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.tabular.DataTableInteractive;
import org.apache.causeway.viewer.wicket.model.hints.CausewaySelectorEvent;
import org.apache.causeway.viewer.wicket.model.links.Menuable;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModel;
import org.apache.causeway.viewer.wicket.model.util.ComponentHintKey;
import org.apache.causeway.viewer.wicket.model.util.PageUtils;
import org.apache.causeway.viewer.wicket.ui.CollectionContentsAsFactory;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.components.collection.selector.CollectionPresentationChoice;
import org.apache.causeway.viewer.wicket.ui.components.collection.selector.CollectionPresentationSelectorHelper;
import org.apache.causeway.viewer.wicket.ui.components.widgets.links.AjaxLinkNoPropagate;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktComponents;
import org.apache.causeway.viewer.wicket.ui.util.WktLinks;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.DownloadLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.jspecify.annotations.NonNull;

public class CollectionPresentationSelectorPanel
extends PanelAbstract<DataTableInteractive, CollectionModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_VIEWS = "views";
    private static final String ID_VIEW_LIST = "viewList";
    private static final String ID_VIEW_LINK = "viewLink";
    private static final String ID_VIEW_ITEM = "viewItem";
    private static final String ID_VIEW_ITEM_TITLE = "viewItemTitle";
    private static final String ID_VIEW_ITEM_ICON = "viewItemIcon";
    private static final String ID_VIEW_ITEM_CHECKMARK = "viewItemCheckmark";
    private static final String ID_VIEW_BUTTON_ICON = "viewButtonIcon";
    private static final String ID_SECTION_SEPARATOR = "sectionSeparator";
    private static final String ID_SECTION_LABEL = "sectionLabel";
    private CollectionPresentationSelectorHelper selectorHelper;
    private final Can<CollectionPresentationChoice> presentationChoices;
    private final ComponentHintKey componentHintKey;
    private CollectionPresentationChoice selectedCollectionPresentationChoice;

    public CollectionPresentationSelectorPanel(String id, CollectionModel model) {
        this(id, model, ComponentHintKey.noop());
    }

    public CollectionPresentationSelectorPanel(String id, CollectionModel model, ComponentHintKey componentHintKey) {
        super(id, model);
        this.componentHintKey = componentHintKey;
        this.selectorHelper = new CollectionPresentationSelectorHelper(model, this.getComponentFactoryRegistry(), componentHintKey);
        this.presentationChoices = this.selectorHelper.collectionPresentationChoices();
    }

    public void onInitialize() {
        super.onInitialize();
        this.addDropdown();
    }

    private void addDropdown() {
        String selected = this.selectorHelper.honourViewHintElseDefault((Component)this);
        if (!this.presentationChoices.isCardinalityMultiple()) {
            WktComponents.permanentlyHide((MarkupContainer)this, ID_VIEWS);
            return;
        }
        this.selectedCollectionPresentationChoice = this.selectorHelper.find(this.presentationChoices, selected);
        WebMarkupContainer views = new WebMarkupContainer(ID_VIEWS);
        WebMarkupContainer container = new WebMarkupContainer(ID_VIEW_LIST);
        views.addOrReplace(new Component[]{container});
        views.setOutputMarkupId(true);
        this.setOutputMarkupId(true);
        Label viewButtonIcon = Wkt.labelAdd((MarkupContainer)views, ID_VIEW_BUTTON_ICON, "");
        Wkt.listViewAdd((MarkupContainer)container, ID_VIEW_ITEM, this.sorted(this.presentationChoices), (SerializableConsumer & Serializable)item -> {
            Menuable menuable = (Menuable)item.getModelObject();
            Menuable.Kind menuableKind = menuable.menuableKind();
            Wkt.cssAppend(item, menuableKind.getCssClassForLiElement());
            switch (menuableKind) {
                case SECTION_SEPARATOR: {
                    WktComponents.permanentlyHide((MarkupContainer)item, ID_SECTION_LABEL);
                    WktComponents.permanentlyHide((MarkupContainer)item, ID_VIEW_LINK);
                    Wkt.labelAdd((MarkupContainer)item, ID_SECTION_SEPARATOR, "");
                    return;
                }
                case SECTION_LABEL: {
                    WktComponents.permanentlyHide((MarkupContainer)item, ID_SECTION_SEPARATOR);
                    WktComponents.permanentlyHide((MarkupContainer)item, ID_VIEW_LINK);
                    Wkt.labelAdd((MarkupContainer)item, ID_SECTION_LABEL, ((Menuable.SectionLabel)menuable).sectionLabel());
                    return;
                }
                case LINK: {
                    WktComponents.permanentlyHide((MarkupContainer)item, ID_SECTION_SEPARATOR);
                    WktComponents.permanentlyHide((MarkupContainer)item, ID_SECTION_LABEL);
                    break;
                }
                default: {
                    return;
                }
            }
            LinkEntry linkEntry = (LinkEntry)menuable;
            CollectionPresentationChoice choice = linkEntry.choice;
            if (choice.isExporter()) {
                DownloadLink downloadLink = (DownloadLink)choice.componentFactory().createComponent(ID_VIEW_LINK, (IModel<?>)this.getModel());
                WktComponents.permanentlyHide((MarkupContainer)downloadLink, ID_VIEW_ITEM_CHECKMARK);
                item.addOrReplace(new Component[]{downloadLink});
                CollectionPresentationSelectorPanel.addLinkWithIconAndTitle((ListItem<? extends Menuable>)item, (MarkupContainer)downloadLink);
                return;
            }
            AjaxLinkNoPropagate link = Wkt.linkAdd((MarkupContainer)item, ID_VIEW_LINK, (SerializableConsumer<AjaxRequestTarget>)(SerializableConsumer & Serializable)target -> {
                CollectionPresentationSelectorPanel linksSelectorPanel = this;
                linksSelectorPanel.setViewHintAndBroadcast(choice.id(), (AjaxRequestTarget)target);
                linksSelectorPanel.selectedCollectionPresentationChoice = choice;
                ((CollectionModel)this.getModel()).parentedHintingBookmark().ifPresent(bookmark -> this.componentHintKey.set(bookmark, choice.id()));
                if (linkEntry.isPageReloadRequiredOnTableViewActivation()) {
                    PageUtils.pageReload();
                } else {
                    target.add(new Component[]{linksSelectorPanel, views});
                }
            });
            CollectionPresentationSelectorPanel.addLinkWithIconAndTitle((ListItem<? extends Menuable>)item, (MarkupContainer)link);
            Label checkmarkForSelectedPresentation = Wkt.labelAdd((MarkupContainer)link, ID_VIEW_ITEM_CHECKMARK, "");
            boolean isSelectedPresentation = linkEntry.isSelectedIn(this);
            checkmarkForSelectedPresentation.setVisible(isSelectedPresentation);
            if (isSelectedPresentation) {
                linkEntry.markAsSelected(viewButtonIcon, link);
            }
        });
        this.addOrReplace(new Component[]{views});
    }

    private List<Menuable> sorted(Can<CollectionPresentationChoice> presentationChoices) {
        List<LinkEntry> presentations = this.sorted(presentationChoices, CollectionPresentationChoice::isPresenter);
        List<LinkEntry> exports = this.sorted(presentationChoices, CollectionPresentationChoice::isExporter);
        ArrayList<Menuable> sortedWithSeparators = new ArrayList<Menuable>(presentations.size() + exports.size() + 2);
        boolean needsSpacer = false;
        if (!presentations.isEmpty()) {
            sortedWithSeparators.add((Menuable)Menuable.sectionLabel((String)this.translate("Presentations")));
            sortedWithSeparators.addAll(presentations);
            needsSpacer = true;
        }
        if (!exports.isEmpty()) {
            if (needsSpacer) {
                sortedWithSeparators.add((Menuable)Menuable.sectionSeparator());
            }
            sortedWithSeparators.add((Menuable)Menuable.sectionLabel((String)this.translate("Exports")));
            sortedWithSeparators.addAll(exports);
        }
        return sortedWithSeparators;
    }

    private List<LinkEntry> sorted(Can<CollectionPresentationChoice> presentationChoices, Predicate<? super CollectionPresentationChoice> filter) {
        List<LinkEntry> sorted = presentationChoices.stream().filter(filter).sorted(CollectionPresentationChoice.orderByOrderOfAppearanceInUiDropdown()).map(LinkEntry::linkEntry).collect(Collectors.toList());
        return sorted;
    }

    protected void setViewHintAndBroadcast(String viewName, AjaxRequestTarget target) {
        CollectionPresentationSelectorPanel component = this;
        this.send((IEventSink)this.getPage(), Broadcast.EXACT, new CausewaySelectorEvent((Component)component, "selectedItem", viewName, target));
    }

    static void addLinkWithIconAndTitle(@NonNull ListItem<? extends Menuable> item, @NonNull MarkupContainer link) {
        WktLinks.listItemAsDropdownLink(item, link, ID_VIEW_ITEM_TITLE, LinkEntry::nameFor, ID_VIEW_ITEM_ICON, null, LinkEntry::cssClassFor);
    }

    record LinkEntry(CollectionPresentationChoice choice) implements Menuable
    {
        public static LinkEntry linkEntry(@NonNull CollectionPresentationChoice choice) {
            return new LinkEntry(choice);
        }

        public Menuable.Kind menuableKind() {
            return Menuable.Kind.LINK;
        }

        boolean isSelectedIn(CollectionPresentationSelectorPanel panel) {
            return Objects.equals(this.choice.factoryKey(), panel.selectedCollectionPresentationChoice.factoryKey());
        }

        boolean isPageReloadRequiredOnTableViewActivation() {
            return this.choice.isPageReloadRequiredOnTableViewActivation();
        }

        boolean isPresenter() {
            return this.choice.isPresenter();
        }

        boolean isExporter() {
            return this.choice.isExporter();
        }

        void markAsSelected(Label viewButtonIcon, AjaxLinkNoPropagate link) {
            LinkEntry.initViewIcon(this, viewButtonIcon);
            Wkt.cssReplace(viewButtonIcon, "ViewLinkItem " + this.choice.cssClass());
            link.setEnabled(false);
        }

        private static IModel<String> nameFor(LinkEntry linkEntry) {
            return Model.of((Serializable)((Object)linkEntry.choice.label()));
        }

        private static IModel<String> cssClassFor(LinkEntry linkEntry, Label viewIcon) {
            LinkEntry.initViewIcon(linkEntry, viewIcon);
            return Model.of((Serializable)((Object)linkEntry.choice.cssClass()));
        }

        private static void initViewIcon(LinkEntry linkEntry, Label viewIcon) {
            if (CollectionContentsAsFactory.class.isAssignableFrom(LinkEntry.componentFactoryClass(linkEntry))) {
                viewIcon.setDefaultModelObject((Object)"");
                viewIcon.setEscapeModelStrings(true);
            } else {
                viewIcon.setDefaultModelObject((Object)"&#160;&#160;&#160;&#160;&#160;");
                viewIcon.setEscapeModelStrings(false);
            }
        }

        private static Class<? extends ComponentFactory> componentFactoryClass(LinkEntry linkEntry) {
            return linkEntry.choice.factoryKey().factoryClass();
        }
    }
}

