/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.tree;

import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributeFragmentFactory;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributePanel;
import org.apache.causeway.viewer.wicket.ui.components.tree.DomainObjectTree;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

public class TreeAttributePanel
extends AttributePanel {
    private static final long serialVersionUID = 1L;

    public TreeAttributePanel(String id, UiAttributeWkt attributeModel) {
        super(id, attributeModel);
    }

    @Override
    protected MarkupContainer createRegularFrame() {
        return AttributeFragmentFactory.FrameFragment.REGULAR.createComponent(this::createTreeComponent);
    }

    @Override
    protected Component createCompactFrame() {
        return AttributeFragmentFactory.FrameFragment.COMPACT.createComponent(this::createTreeComponent);
    }

    @Override
    protected void setupInlinePrompt() {
    }

    @Override
    protected void onMakeNotEditable(String disableReason) {
    }

    @Override
    protected void onMakeEditable() {
    }

    @Override
    protected Component getValidationFeedbackReceiver() {
        return null;
    }

    private MarkupContainer createTreeComponent(String id) {
        WebMarkupContainer container = this.getScalarFrameContainer();
        UiAttributeWkt attributeModel = this.attributeModel();
        MarkupContainer tree = DomainObjectTree.createComponent(id, (IModel<ManagedObject>)attributeModel);
        container.add(new Component[]{tree});
        container.add(new Behavior[]{this.getTreeThemeProvider().treeThemeFor(attributeModel)});
        return tree;
    }
}

