/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.errors;

import java.io.Serializable;

public record StackTraceDetail(Type type, String line) implements Serializable
{
    public static StackTraceDetail exceptionClassName(Throwable cause) {
        return new StackTraceDetail(Type.EXCEPTION_CLASS_NAME, cause.getClass().getName());
    }

    public static StackTraceDetail exceptionMessage(Throwable cause) {
        return new StackTraceDetail(Type.EXCEPTION_MESSAGE, cause.getMessage());
    }

    public static StackTraceDetail element(StackTraceElement el) {
        StringBuilder buf = new StringBuilder();
        buf.append("    ").append(el.getClassName()).append("#").append(el.getMethodName()).append("(").append(el.getFileName()).append(":").append(el.getLineNumber()).append(")\n");
        return new StackTraceDetail(Type.STACKTRACE_ELEMENT, buf.toString());
    }

    public static StackTraceDetail spacer() {
        return new StackTraceDetail(Type.LITERAL, "");
    }

    public static StackTraceDetail causedBy() {
        return new StackTraceDetail(Type.LITERAL, "Caused by:");
    }

    static enum Type {
        EXCEPTION_CLASS_NAME,
        EXCEPTION_MESSAGE,
        STACKTRACE_ELEMENT,
        LITERAL;

    }
}

