/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.exec;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import lombok.Generated;
import org.apache.causeway.applib.value.Blob;
import org.apache.causeway.applib.value.Clob;
import org.apache.causeway.applib.value.NamedWithMimeType;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.resource.StringResourceStream;

final class DownloadHandlerFactory {
    public static IRequestHandler downloadHandler(ObjectAction action, Object value) {
        if (value instanceof Clob) {
            Clob clob = (Clob)value;
            return DownloadHandlerFactory.handlerFor(action, DownloadHandlerFactory.resourceStreamFor(clob), (NamedWithMimeType)clob);
        }
        if (value instanceof Blob) {
            Blob blob = (Blob)value;
            return DownloadHandlerFactory.handlerFor(action, DownloadHandlerFactory.resourceStreamFor(blob), (NamedWithMimeType)blob);
        }
        return null;
    }

    private static IResourceStream resourceStreamFor(final Blob blob) {
        AbstractResourceStream resourceStream = new AbstractResourceStream(){
            private static final long serialVersionUID = 1L;

            public InputStream getInputStream() throws ResourceStreamNotFoundException {
                return new ByteArrayInputStream(blob.bytes());
            }

            public String getContentType() {
                return blob.mimeType().toString();
            }

            public void close() throws IOException {
            }
        };
        return resourceStream;
    }

    private static IResourceStream resourceStreamFor(Clob clob) {
        return new StringResourceStream(clob.chars(), clob.mimeType().toString());
    }

    private static IRequestHandler handlerFor(ObjectAction action, IResourceStream resourceStream, NamedWithMimeType namedWithMimeType) {
        ResourceStreamRequestHandler handler = new ResourceStreamRequestHandler(resourceStream, namedWithMimeType.name());
        handler.setContentDisposition(ContentDisposition.ATTACHMENT);
        return action.getSemantics().isIdempotentOrCachable() ? handler : DownloadHandlerFactory.enforceNoCacheOnClientSide((IRequestHandler)handler);
    }

    private static IRequestHandler enforceNoCacheOnClientSide(IRequestHandler downloadHandler) {
        if (downloadHandler == null) {
            return downloadHandler;
        }
        if (downloadHandler instanceof ResourceStreamRequestHandler) {
            ((ResourceStreamRequestHandler)downloadHandler).setCacheDuration(Duration.ZERO);
        }
        return downloadHandler;
    }

    @Generated
    private DownloadHandlerFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

