/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.exec;

import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.viewer.wicket.model.util.PageParameterUtils;
import org.apache.wicket.core.request.handler.BookmarkablePageRequestHandler;
import org.apache.wicket.core.request.handler.IPageProvider;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

record PageRedirectRequest<T extends IRequestablePage>(@NonNull Class<T> pageClass, @Nullable PageParameters pageParameters, @Nullable IRequestablePage pageInstance) {
    static <T extends IRequestablePage> PageRedirectRequest<T> forPageClass(@NonNull Class<T> pageClass, @NonNull PageParameters pageParameters) {
        return new PageRedirectRequest<T>(pageClass, pageParameters, null);
    }

    static <T extends IRequestablePage> PageRedirectRequest<T> forPageClassAndBookmark(@NonNull Class<T> pageClass, @NonNull Bookmark bookmark) {
        return PageRedirectRequest.forPageClass(pageClass, PageParameterUtils.createPageParametersForBookmark((Bookmark)bookmark));
    }

    static <T extends IRequestablePage> PageRedirectRequest<T> forPageClass(@NonNull Class<T> pageClass) {
        return new PageRedirectRequest<T>(pageClass, null, null);
    }

    static <T extends IRequestablePage> PageRedirectRequest<T> forPage(@NonNull Class<T> pageClass, @NonNull T pageInstance) {
        return new PageRedirectRequest<T>(pageClass, null, pageInstance);
    }

    String toUrl() {
        BookmarkablePageRequestHandler handler = new BookmarkablePageRequestHandler((IPageProvider)new PageProvider(this.pageClass, this.pageParameters));
        return RequestCycle.get().urlFor((IRequestHandler)handler).toString();
    }

    void apply() {
        RequestCycle requestCycle = RequestCycle.get();
        if (requestCycle == null) {
            return;
        }
        if (this.pageParameters != null) {
            requestCycle.setResponsePage(this.pageClass, this.pageParameters);
            return;
        }
        if (this.pageInstance != null) {
            requestCycle.setResponsePage(this.pageInstance);
            return;
        }
        requestCycle.setResponsePage(this.pageClass);
    }
}

