/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.viewer.webmodule;

import java.util.Objects;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import lombok.Generated;
import org.apache.causeway.applib.services.inject.ServiceInjector;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.config.environment.CausewaySystemEnvironment;
import org.apache.causeway.core.webapp.modules.WebModuleAbstract;
import org.apache.causeway.core.webapp.modules.WebModuleContext;
import org.apache.wicket.protocol.http.WicketFilter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.viewer.wicket.WebModuleWicket")
@Priority(value=0x3FFFFFAF)
@Qualifier(value="Wicket")
public final class WebModuleWicket
extends WebModuleAbstract {
    private static final String WICKET_FILTER_NAME = "WicketFilter";
    private final CausewaySystemEnvironment causewaySystemEnvironment;
    private final CausewayConfiguration causewayConfiguration;
    private final String wicketBasePath;
    private final String deploymentMode;
    private final String wicketApp;
    private final String urlPattern;
    private final String name = "Wicket";

    @Inject
    public WebModuleWicket(CausewaySystemEnvironment causewaySystemEnvironment, CausewayConfiguration causewayConfiguration, ServiceInjector serviceInjector) {
        super(serviceInjector);
        this.causewaySystemEnvironment = causewaySystemEnvironment;
        this.causewayConfiguration = causewayConfiguration;
        this.wicketBasePath = this.causewayConfiguration.getViewer().getWicket().getBasePath();
        this.deploymentMode = this.causewaySystemEnvironment.isPrototyping() ? "development" : "deployment";
        this.wicketApp = causewayConfiguration.getViewer().getWicket().getApp();
        Objects.requireNonNull(this.wicketBasePath, "Config property 'causeway.viewer.wicket.base-path' is required.");
        Objects.requireNonNull(this.wicketApp, "Config property 'causeway.viewer.wicket.app' is required.");
        this.urlPattern = this.wicketBasePath + "*";
    }

    public void prepare(WebModuleContext ctx) {
        super.prepare(ctx);
        ctx.addProtectedPath(this.urlPattern);
    }

    public Can<ServletContextListener> init(ServletContext ctx) throws ServletException {
        this.registerFilter(ctx, WICKET_FILTER_NAME, WicketFilter.class).ifPresent(filterReg -> {
            filterReg.setInitParameter("applicationClassName", this.wicketApp);
            filterReg.setInitParameter("filterMappingUrlPattern", this.urlPattern);
            filterReg.setInitParameter("configuration", this.deploymentMode);
            filterReg.addMappingForUrlPatterns(null, true, new String[]{this.urlPattern});
        });
        return Can.empty();
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

