/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.viewer.integration;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.wicket.Application;
import org.apache.wicket.Localizer;
import org.apache.wicket.resource.loader.ClassStringResourceLoader;
import org.apache.wicket.resource.loader.ComponentStringResourceLoader;
import org.apache.wicket.resource.loader.IStringResourceLoader;
import org.apache.wicket.resource.loader.InitializerStringResourceLoader;
import org.apache.wicket.resource.loader.PackageStringResourceLoader;
import org.apache.wicket.resource.loader.ValidatorStringResourceLoader;
import org.apache.wicket.settings.ResourceSettings;
import org.apache.wicket.util.lang.Generics;

public class CausewayResourceSettings
extends ResourceSettings {
    private final List<IStringResourceLoader> stringResourceLoaders = Generics.newArrayList((int)4);
    private final AtomicReference<Object> localizer = new AtomicReference();

    public CausewayResourceSettings(Application application) {
        super(application);
        this.stringResourceLoaders.add((IStringResourceLoader)new ClassStringResourceLoader(application.getClass()));
        this.stringResourceLoaders.add((IStringResourceLoader)new ComponentStringResourceLoader());
        this.stringResourceLoaders.add((IStringResourceLoader)new PackageStringResourceLoader());
        this.stringResourceLoaders.add((IStringResourceLoader)new ValidatorStringResourceLoader());
        this.stringResourceLoaders.add((IStringResourceLoader)new InitializerStringResourceLoader(application.getInitializers()));
    }

    public List<IStringResourceLoader> getStringResourceLoaders() {
        return this.stringResourceLoaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Localizer getLocalizer() {
        Object $value = this.localizer.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.localizer;
            synchronized (atomicReference) {
                $value = this.localizer.get();
                if ($value == null) {
                    Localizer actualValue = new Localizer();
                    $value = actualValue == null ? this.localizer : actualValue;
                    this.localizer.set($value);
                }
            }
        }
        return (Localizer)($value == this.localizer ? null : $value);
    }
}

