/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.viewer.services;

import jakarta.inject.Named;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import lombok.Generated;
import org.apache.causeway.core.metamodel.facets.object.icon.ObjectIcon;
import org.apache.causeway.viewer.wicket.model.models.ImageResourceCache;
import org.apache.wicket.Application;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.PartWriterCallback;
import org.apache.wicket.request.resource.ResourceReference;
import org.jspecify.annotations.NonNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

public class ImageResourceCacheClassPath
implements ImageResourceCache {
    public static final String LOGICAL_TYPE_NAME = "causeway.viewer.wicket.ImageResourceCacheClassPath";
    private static final long serialVersionUID = 1L;

    public ResourceReference resourceReferenceForObjectIcon(ObjectIcon objectIcon) {
        return new ObjectIconResourceReference(objectIcon);
    }

    private static class ObjectIconResourceReference
    extends ResourceReference {
        private static final long serialVersionUID = 1L;
        private final @NonNull ObjectIconResource objectIconResource;

        public ObjectIconResourceReference(ObjectIcon objectIcon) {
            super(new ResourceReference.Key(Application.class.getName(), objectIcon.getIdentifier(), null, null, null));
            this.objectIconResource = new ObjectIconResource(objectIcon);
        }

        public IResource getResource() {
            return this.objectIconResource;
        }
    }

    private static class ObjectIconResource
    extends AbstractResource {
        private static final long serialVersionUID = 1L;
        private final @NonNull ObjectIcon objectIcon;

        protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
            byte[] imageDataBytes = this.objectIcon.asBytes();
            long size = imageDataBytes.length;
            AbstractResource.ResourceResponse resourceResponse = new AbstractResource.ResourceResponse();
            resourceResponse.setContentType(this.objectIcon.getMimeType().getBaseType());
            resourceResponse.setAcceptRange(AbstractResource.ContentRangeType.BYTES);
            resourceResponse.setContentLength(size);
            resourceResponse.setFileName(this.objectIcon.getShortName());
            RequestCycle cycle = RequestCycle.get();
            Long startbyte = (Long)cycle.getMetaData(CONTENT_RANGE_STARTBYTE);
            Long endbyte = (Long)cycle.getMetaData(CONTENT_RANGE_ENDBYTE);
            resourceResponse.setWriteCallback((AbstractResource.WriteCallback)new PartWriterCallback((InputStream)new ByteArrayInputStream(imageDataBytes), Long.valueOf(size), startbyte, endbyte).setClose(true));
            return resourceResponse;
        }

        @Generated
        public ObjectIconResource(@NonNull ObjectIcon objectIcon) {
            if (objectIcon == null) {
                throw new NullPointerException("objectIcon is marked non-null but is null");
            }
            this.objectIcon = objectIcon;
        }
    }

    @Configuration
    public static class AutoConfiguration {
        @Bean
        @Named(value="causeway.viewer.wicket.ImageResourceCacheClassPath")
        @Order(value=0x3FFFFFFF)
        @Qualifier(value="ClassPath")
        public ImageResourceCacheClassPath imageResourceCacheClassPath() {
            return new ImageResourceCacheClassPath();
        }
    }
}

