/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.viewer.registries.pages;

import jakarta.inject.Named;
import org.apache.causeway.viewer.wicket.model.models.PageType;
import org.apache.causeway.viewer.wicket.ui.pages.PageClassList;
import org.apache.causeway.viewer.wicket.ui.pages.PageClassRegistrySpi;
import org.apache.causeway.viewer.wicket.ui.pages.about.AboutPage;
import org.apache.causeway.viewer.wicket.ui.pages.accmngt.password_reset.PasswordResetPage;
import org.apache.causeway.viewer.wicket.ui.pages.accmngt.register.RegisterPage;
import org.apache.causeway.viewer.wicket.ui.pages.accmngt.signup.RegistrationFormPage;
import org.apache.causeway.viewer.wicket.ui.pages.home.HomePage;
import org.apache.causeway.viewer.wicket.ui.pages.login.WicketSignInPage;
import org.apache.causeway.viewer.wicket.ui.pages.obj.DomainObjectPage;
import org.apache.causeway.viewer.wicket.ui.pages.standalonecollection.StandaloneCollectionPage;
import org.apache.causeway.viewer.wicket.ui.pages.value.ValuePage;
import org.apache.causeway.viewer.wicket.ui.pages.voidreturn.VoidReturnPage;
import org.apache.wicket.Page;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

public class PageClassListDefault
implements PageClassList {
    private static final long serialVersionUID = 1L;

    public void registerPages(PageClassRegistrySpi pageRegistry) {
        pageRegistry.registerPage(PageType.SIGN_IN, this.getSignInPageClass());
        pageRegistry.registerPage(PageType.SIGN_UP, this.getSignUpPageClass());
        pageRegistry.registerPage(PageType.SIGN_UP_VERIFY, this.getSignUpVerifyPageClass());
        pageRegistry.registerPage(PageType.PASSWORD_RESET, this.getPasswordResetPageClass());
        pageRegistry.registerPage(PageType.ABOUT, this.getAboutPageClass());
        pageRegistry.registerPage(PageType.DOMAIN_OBJECT, this.getDomainObjectPageClass());
        pageRegistry.registerPage(PageType.HOME, this.getHomePageClass());
        pageRegistry.registerPage(PageType.HOME_AFTER_PAGETIMEOUT, this.getHomePageClass());
        pageRegistry.registerPage(PageType.STANDALONE_COLLECTION, this.getStandaloneCollectionPageClass());
        pageRegistry.registerPage(PageType.VALUE, this.getValuePageClass());
        pageRegistry.registerPage(PageType.VOID_RETURN, this.getVoidReturnPageClass());
    }

    protected Class<? extends Page> getDomainObjectPageClass() {
        return DomainObjectPage.class;
    }

    protected Class<? extends Page> getStandaloneCollectionPageClass() {
        return StandaloneCollectionPage.class;
    }

    protected Class<? extends Page> getValuePageClass() {
        return ValuePage.class;
    }

    protected Class<? extends Page> getVoidReturnPageClass() {
        return VoidReturnPage.class;
    }

    protected Class<? extends Page> getSignInPageClass() {
        return WicketSignInPage.class;
    }

    protected Class<? extends Page> getSignUpPageClass() {
        return RegistrationFormPage.class;
    }

    protected Class<? extends Page> getSignUpVerifyPageClass() {
        return RegisterPage.class;
    }

    protected Class<? extends Page> getPasswordResetPageClass() {
        return PasswordResetPage.class;
    }

    protected Class<? extends Page> getHomePageClass() {
        return HomePage.class;
    }

    protected Class<? extends Page> getAboutPageClass() {
        return AboutPage.class;
    }

    @Configuration
    public static class AutoConfiguration {
        @Bean
        @Named(value="causeway.viewer.wicket.PageClassListDefault")
        @ConditionalOnMissingBean(value={PageClassList.class})
        @Order(value=0x3FFFFFFF)
        @Qualifier(value="Default")
        public PageClassList pageClassListDefault() {
            return new PageClassListDefault();
        }
    }
}

