/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.fileshare;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.BulkUpdateObjectIdAndChangeToken;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectListImpl;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractCmisService;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.ObjectInfoHandler;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.fileshare.FileShareRepository;
import org.apache.chemistry.opencmis.fileshare.FileShareRepositoryManager;
import org.apache.chemistry.opencmis.server.support.wrapper.CallContextAwareCmisService;

public class FileShareCmisService
extends AbstractCmisService
implements CallContextAwareCmisService {
    private final FileShareRepositoryManager repositoryManager;
    private CallContext context;

    public FileShareCmisService(FileShareRepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public void setCallContext(CallContext context) {
        this.context = context;
    }

    public CallContext getCallContext() {
        return this.context;
    }

    public FileShareRepository getRepository() {
        return this.repositoryManager.getRepository(this.getCallContext().getRepositoryId());
    }

    public RepositoryInfo getRepositoryInfo(String repositoryId, ExtensionsData extension) {
        for (FileShareRepository fsr : this.repositoryManager.getRepositories()) {
            if (!fsr.getRepositoryId().equals(repositoryId)) continue;
            return fsr.getRepositoryInfo(this.getCallContext());
        }
        throw new CmisObjectNotFoundException("Unknown repository '" + repositoryId + "'!");
    }

    public List<RepositoryInfo> getRepositoryInfos(ExtensionsData extension) {
        ArrayList<RepositoryInfo> result = new ArrayList<RepositoryInfo>();
        for (FileShareRepository fsr : this.repositoryManager.getRepositories()) {
            result.add(fsr.getRepositoryInfo(this.getCallContext()));
        }
        return result;
    }

    public TypeDefinitionList getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return this.getRepository().getTypeChildren(this.getCallContext(), typeId, includePropertyDefinitions, maxItems, skipCount);
    }

    public TypeDefinition getTypeDefinition(String repositoryId, String typeId, ExtensionsData extension) {
        return this.getRepository().getTypeDefinition(this.getCallContext(), typeId);
    }

    public List<TypeDefinitionContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, ExtensionsData extension) {
        return this.getRepository().getTypeDescendants(this.getCallContext(), typeId, depth, includePropertyDefinitions);
    }

    public ObjectInFolderList getChildren(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return this.getRepository().getChildren(this.getCallContext(), folderId, filter, orderBy, includeAllowableActions, includePathSegment, maxItems, skipCount, (ObjectInfoHandler)this);
    }

    public List<ObjectInFolderContainer> getDescendants(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        return this.getRepository().getDescendants(this.getCallContext(), folderId, depth, filter, includeAllowableActions, includePathSegment, (ObjectInfoHandler)this, false);
    }

    public ObjectData getFolderParent(String repositoryId, String folderId, String filter, ExtensionsData extension) {
        return this.getRepository().getFolderParent(this.getCallContext(), folderId, filter, (ObjectInfoHandler)this);
    }

    public List<ObjectInFolderContainer> getFolderTree(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        return this.getRepository().getDescendants(this.getCallContext(), folderId, depth, filter, includeAllowableActions, includePathSegment, (ObjectInfoHandler)this, true);
    }

    public List<ObjectParentData> getObjectParents(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includeRelativePathSegment, ExtensionsData extension) {
        return this.getRepository().getObjectParents(this.getCallContext(), objectId, filter, includeAllowableActions, includeRelativePathSegment, (ObjectInfoHandler)this);
    }

    public ObjectList getCheckedOutDocs(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        ObjectListImpl result = new ObjectListImpl();
        result.setHasMoreItems(Boolean.valueOf(false));
        result.setNumItems(BigInteger.ZERO);
        List emptyList = Collections.emptyList();
        result.setObjects(emptyList);
        return result;
    }

    public String create(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, ExtensionsData extension) {
        ObjectData object = this.getRepository().create(this.getCallContext(), properties, folderId, contentStream, versioningState, (ObjectInfoHandler)this);
        return object.getId();
    }

    public String createDocument(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        return this.getRepository().createDocument(this.getCallContext(), properties, folderId, contentStream, versioningState);
    }

    public String createDocumentFromSource(String repositoryId, String sourceId, Properties properties, String folderId, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        return this.getRepository().createDocumentFromSource(this.getCallContext(), sourceId, properties, folderId, versioningState);
    }

    public String createFolder(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        return this.getRepository().createFolder(this.getCallContext(), properties, folderId);
    }

    public void deleteObjectOrCancelCheckOut(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        this.getRepository().deleteObject(this.getCallContext(), objectId);
    }

    public FailedToDeleteData deleteTree(String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, Boolean continueOnFailure, ExtensionsData extension) {
        return this.getRepository().deleteTree(this.getCallContext(), folderId, continueOnFailure);
    }

    public AllowableActions getAllowableActions(String repositoryId, String objectId, ExtensionsData extension) {
        return this.getRepository().getAllowableActions(this.getCallContext(), objectId);
    }

    public ContentStream getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, ExtensionsData extension) {
        return this.getRepository().getContentStream(this.getCallContext(), objectId, offset, length);
    }

    public ObjectData getObject(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        return this.getRepository().getObject(this.getCallContext(), objectId, null, filter, includeAllowableActions, includeAcl, (ObjectInfoHandler)this);
    }

    public ObjectData getObjectByPath(String repositoryId, String path, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        return this.getRepository().getObjectByPath(this.getCallContext(), path, filter, includeAllowableActions, includeAcl, (ObjectInfoHandler)this);
    }

    public Properties getProperties(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        ObjectData object = this.getRepository().getObject(this.getCallContext(), objectId, null, filter, false, false, (ObjectInfoHandler)this);
        return object.getProperties();
    }

    public List<RenditionData> getRenditions(String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return Collections.emptyList();
    }

    public void moveObject(String repositoryId, Holder<String> objectId, String targetFolderId, String sourceFolderId, ExtensionsData extension) {
        this.getRepository().moveObject(this.getCallContext(), objectId, targetFolderId, (ObjectInfoHandler)this);
    }

    public void setContentStream(String repositoryId, Holder<String> objectId, Boolean overwriteFlag, Holder<String> changeToken, ContentStream contentStream, ExtensionsData extension) {
        this.getRepository().changeContentStream(this.getCallContext(), objectId, overwriteFlag, contentStream, false);
    }

    public void appendContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ContentStream contentStream, boolean isLastChunk, ExtensionsData extension) {
        this.getRepository().changeContentStream(this.getCallContext(), objectId, true, contentStream, true);
    }

    public void deleteContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ExtensionsData extension) {
        this.getRepository().changeContentStream(this.getCallContext(), objectId, true, null, false);
    }

    public void updateProperties(String repositoryId, Holder<String> objectId, Holder<String> changeToken, Properties properties, ExtensionsData extension) {
        this.getRepository().updateProperties(this.getCallContext(), objectId, properties, (ObjectInfoHandler)this);
    }

    public List<BulkUpdateObjectIdAndChangeToken> bulkUpdateProperties(String repositoryId, List<BulkUpdateObjectIdAndChangeToken> objectIdAndChangeToken, Properties properties, List<String> addSecondaryTypeIds, List<String> removeSecondaryTypeIds, ExtensionsData extension) {
        return this.getRepository().bulkUpdateProperties(this.getCallContext(), objectIdAndChangeToken, properties, (ObjectInfoHandler)this);
    }

    public List<ObjectData> getAllVersions(String repositoryId, String objectId, String versionSeriesId, String filter, Boolean includeAllowableActions, ExtensionsData extension) {
        ObjectData theVersion = this.getRepository().getObject(this.getCallContext(), objectId, versionSeriesId, filter, includeAllowableActions, false, (ObjectInfoHandler)this);
        return Collections.singletonList(theVersion);
    }

    public ObjectData getObjectOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        return this.getRepository().getObject(this.getCallContext(), objectId, versionSeriesId, filter, includeAllowableActions, includeAcl, (ObjectInfoHandler)this);
    }

    public Properties getPropertiesOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, ExtensionsData extension) {
        ObjectData object = this.getRepository().getObject(this.getCallContext(), objectId, versionSeriesId, filter, false, false, null);
        return object.getProperties();
    }

    public Acl getAcl(String repositoryId, String objectId, Boolean onlyBasicPermissions, ExtensionsData extension) {
        return this.getRepository().getAcl(this.getCallContext(), objectId);
    }
}

