/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.fileshare;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.fileshare.FileShareRepository;

public class FileShareRepositoryManager {
    private final Map<String, FileShareRepository> repositories = new HashMap<String, FileShareRepository>();

    public void addRepository(FileShareRepository fsr) {
        if (fsr == null || fsr.getRepositoryId() == null) {
            return;
        }
        this.repositories.put(fsr.getRepositoryId(), fsr);
    }

    public FileShareRepository getRepository(String repositoryId) {
        FileShareRepository result = this.repositories.get(repositoryId);
        if (result == null) {
            throw new CmisObjectNotFoundException("Unknown repository '" + repositoryId + "'!");
        }
        return result;
    }

    public Collection<FileShareRepository> getRepositories() {
        return this.repositories.values();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        for (FileShareRepository repository : this.repositories.values()) {
            sb.append('[');
            sb.append(repository.getRepositoryId());
            sb.append(" -> ");
            sb.append(repository.getRootDirectory().getAbsolutePath());
            sb.append(']');
        }
        return sb.toString();
    }
}

