/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.fileshare;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.chemistry.opencmis.commons.definitions.MutableDocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutableFolderTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutablePropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutablePropertyIdDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutableTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.XMLConverter;
import org.apache.chemistry.opencmis.commons.impl.XMLUtils;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.server.support.TypeDefinitionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileShareTypeManager {
    private static final Logger LOG = LoggerFactory.getLogger(FileShareTypeManager.class);
    private static final String NAMESPACE = "http://chemistry.apache.org/opencmis/fileshare";
    private final TypeDefinitionFactory typeDefinitionFactory = TypeDefinitionFactory.newInstance();
    private final Map<String, TypeDefinition> typeDefinitions;

    public FileShareTypeManager() {
        this.typeDefinitionFactory.setDefaultNamespace(NAMESPACE);
        this.typeDefinitionFactory.setDefaultControllableAcl(false);
        this.typeDefinitionFactory.setDefaultControllablePolicy(false);
        this.typeDefinitionFactory.setDefaultQueryable(false);
        this.typeDefinitionFactory.setDefaultFulltextIndexed(false);
        this.typeDefinitionFactory.setDefaultTypeMutability(this.typeDefinitionFactory.createTypeMutability(false, false, false));
        this.typeDefinitions = new HashMap<String, TypeDefinition>();
        MutableFolderTypeDefinition folderType = this.typeDefinitionFactory.createBaseFolderTypeDefinition(CmisVersion.CMIS_1_1);
        ((MutablePropertyIdDefinition)folderType.getPropertyDefinitions().get("cmis:objectId")).setIsOrderable(Boolean.TRUE);
        ((MutablePropertyIdDefinition)folderType.getPropertyDefinitions().get("cmis:baseTypeId")).setIsOrderable(Boolean.TRUE);
        this.typeDefinitions.put(folderType.getId(), (TypeDefinition)folderType);
        MutableDocumentTypeDefinition documentType = this.typeDefinitionFactory.createBaseDocumentTypeDefinition(CmisVersion.CMIS_1_1);
        ((MutablePropertyIdDefinition)documentType.getPropertyDefinitions().get("cmis:objectId")).setIsOrderable(Boolean.TRUE);
        ((MutablePropertyIdDefinition)documentType.getPropertyDefinitions().get("cmis:baseTypeId")).setIsOrderable(Boolean.TRUE);
        this.typeDefinitions.put(documentType.getId(), (TypeDefinition)documentType);
    }

    public synchronized void addTypeDefinition(TypeDefinition type) {
        if (type == null) {
            throw new IllegalArgumentException("Type must be set!");
        }
        if (type.getId() == null || type.getId().trim().length() == 0) {
            throw new IllegalArgumentException("Type must have a valid id!");
        }
        if (type.getParentTypeId() == null || type.getParentTypeId().trim().length() == 0) {
            throw new IllegalArgumentException("Type must have a valid parent id!");
        }
        TypeDefinition parentType = this.typeDefinitions.get(type.getParentTypeId());
        if (parentType == null) {
            throw new IllegalArgumentException("Parent type doesn't exist!");
        }
        MutableTypeDefinition newType = this.typeDefinitionFactory.copy(type, true);
        for (PropertyDefinition propDef : parentType.getPropertyDefinitions().values()) {
            MutablePropertyDefinition basePropDef = this.typeDefinitionFactory.copy(propDef);
            basePropDef.setIsInherited(Boolean.valueOf(true));
            newType.addPropertyDefinition((PropertyDefinition)basePropDef);
        }
        this.typeDefinitions.put(newType.getId(), (TypeDefinition)newType);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Added type '{}'.", (Object)type.getId());
        }
    }

    public void loadTypeDefinitionFromFile(String filename) throws IOException, XMLStreamException {
        this.loadTypeDefinitionFromStream(new BufferedInputStream(new FileInputStream(filename), 65536));
    }

    public void loadTypeDefinitionFromResource(String name) throws IOException, XMLStreamException {
        this.loadTypeDefinitionFromStream(this.getClass().getResourceAsStream(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTypeDefinitionFromStream(InputStream stream) throws IOException, XMLStreamException {
        if (stream == null) {
            throw new IllegalArgumentException("Stream is null!");
        }
        TypeDefinition type = null;
        XMLStreamReader parser = null;
        try {
            parser = XMLUtils.createParser((InputStream)stream);
            if (!XMLUtils.findNextStartElemenet((XMLStreamReader)parser)) {
                return;
            }
            type = XMLConverter.convertTypeDefinition((XMLStreamReader)parser);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
            IOUtils.closeQuietly((Closeable)stream);
        }
        this.addTypeDefinition(type);
    }

    public synchronized TypeDefinition getInternalTypeDefinition(String typeId) {
        return this.typeDefinitions.get(typeId);
    }

    public synchronized Collection<TypeDefinition> getInternalTypeDefinitions() {
        return this.typeDefinitions.values();
    }

    public TypeDefinition getTypeDefinition(CallContext context, String typeId) {
        TypeDefinition type = this.typeDefinitions.get(typeId);
        if (type == null) {
            throw new CmisObjectNotFoundException("Type '" + typeId + "' is unknown!");
        }
        return this.typeDefinitionFactory.copy(type, true, context.getCmisVersion());
    }

    public TypeDefinitionList getTypeChildren(CallContext context, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount) {
        return this.typeDefinitionFactory.createTypeDefinitionList(this.typeDefinitions, typeId, includePropertyDefinitions, maxItems, skipCount, context.getCmisVersion());
    }

    public List<TypeDefinitionContainer> getTypeDescendants(CallContext context, String typeId, BigInteger depth, Boolean includePropertyDefinitions) {
        return this.typeDefinitionFactory.createTypeDescendants(this.typeDefinitions, typeId, depth, includePropertyDefinitions, context.getCmisVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        for (TypeDefinition type : this.typeDefinitions.values()) {
            sb.append('[');
            sb.append(type.getId());
            sb.append(" (");
            sb.append(type.getBaseTypeId().value());
            sb.append(")]");
        }
        return sb.toString();
    }
}

