/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.browser;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class BrowseServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(BrowseServlet.class);
    private static final String CONTEXT_PREFIX = "{ctx}";
    private static final String PARAM_URL = "url";
    private static final String PARAM_OVERRIDE_STYLESHEET = "overrideStylesheet";
    private static final int PARAM_URL_MIN_LEN = "url".length() + "=".length() + "http".length() + "://".length() + 1;
    private static final String INIT_PARAM_AUXROOT = "auxroot";
    private static final String INIT_PARAM_ALLOW = "allow";
    private static final String INIT_PARAM_STYLESHEET = "stylesheet:";
    private static final String INIT_PARAM_OVERRIDE_STYLESHEET = "override-stylesheet:";
    private static final int BUFFER_SIZE = 65536;
    private String fAuxRoot = "";
    private String fAllow = ".*";
    private Map<String, Source> fStyleSheets;
    private Map<String, Source> fOverrideStyleSheets;

    public void init(ServletConfig config) throws ServletException {
        String initAllow;
        this.fStyleSheets = new HashMap<String, Source>();
        this.fOverrideStyleSheets = new HashMap<String, Source>();
        DocumentBuilder builder = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            builder = builderFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return;
        }
        Enumeration initParams = config.getInitParameterNames();
        while (initParams.hasMoreElements()) {
            String param = (String)initParams.nextElement();
            String stylesheetKey = null;
            boolean isOverride = false;
            if (param.startsWith(INIT_PARAM_STYLESHEET)) {
                stylesheetKey = param.substring(INIT_PARAM_STYLESHEET.length());
            } else if (param.startsWith(INIT_PARAM_OVERRIDE_STYLESHEET)) {
                stylesheetKey = param.substring(INIT_PARAM_OVERRIDE_STYLESHEET.length());
                isOverride = true;
            }
            if (stylesheetKey == null) continue;
            String stylesheetFileName = config.getInitParameter(param);
            InputStream stream = config.getServletContext().getResourceAsStream(stylesheetFileName);
            if (stream == null) continue;
            try {
                Document xslDoc = builder.parse(stream);
                this.addStylesheet(stylesheetKey, new DOMSource(xslDoc), isOverride);
                LOG.info("Stylesheet: '" + stylesheetKey + "' -> '" + stylesheetFileName + "'");
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        String initAuxRoot = config.getInitParameter(INIT_PARAM_AUXROOT);
        if (initAuxRoot != null) {
            this.fAuxRoot = initAuxRoot;
            LOG.info("Auxiliary root: " + this.fAuxRoot);
        }
        if ((initAllow = config.getInitParameter(INIT_PARAM_ALLOW)) != null) {
            this.fAllow = initAllow;
            LOG.info("Allow pattern: " + this.fAllow);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String browseUrl = null;
        String overrideStylesheet = null;
        String queryString = req.getQueryString();
        if (queryString != null && queryString.startsWith(PARAM_URL)) {
            int urlEnd = queryString.indexOf("overrideStylesheet=");
            if (urlEnd == -1) {
                urlEnd = queryString.length();
            } else {
                overrideStylesheet = queryString.substring(urlEnd + PARAM_OVERRIDE_STYLESHEET.length() + 1);
                --urlEnd;
            }
            browseUrl = queryString.substring(PARAM_URL.length() + 1, urlEnd);
            if (browseUrl.length() < PARAM_URL_MIN_LEN) {
                browseUrl = null;
            }
        }
        if (browseUrl == null) {
            this.printInput(req, resp);
            return;
        }
        this.doBrowse(req, resp, browseUrl, overrideStylesheet);
    }

    protected void doBrowse(HttpServletRequest req, HttpServletResponse resp, String browseUrl, String overrideStylesheet) throws ServletException, IOException {
        if (browseUrl.charAt(4) != ':' && browseUrl.charAt(5) != ':') {
            browseUrl = URLDecoder.decode(browseUrl, "UTF-8");
        }
        if (!browseUrl.matches(this.fAllow)) {
            this.printError(req, resp, "Prohibited URL!", null);
            return;
        }
        try {
            URL url = new URL(browseUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoInput(true);
            conn.setDoOutput(false);
            conn.setRequestMethod("GET");
            String authHeader = req.getHeader("Authorization");
            if (authHeader != null) {
                conn.setRequestProperty("Authorization", authHeader);
            }
            conn.connect();
            if (conn.getResponseCode() == 401) {
                resp.setHeader("WWW-Authenticate", conn.getHeaderField("WWW-Authenticate"));
                resp.sendError(401, "Authorization Required");
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("'" + browseUrl + "' -> '" + conn.getContentType() + "'");
            }
            Source stylesheet = this.getStylesheet(conn.getContentType(), overrideStylesheet);
            BufferedOutputStream out = null;
            BufferedInputStream in = new BufferedInputStream(conn.getInputStream(), 65536);
            if (stylesheet == null) {
                int b;
                resp.setContentType(conn.getContentType());
                out = new BufferedOutputStream((OutputStream)resp.getOutputStream(), 65536);
                byte[] buffer = new byte[65536];
                while ((b = ((InputStream)in).read(buffer)) > -1) {
                    ((OutputStream)out).write(buffer, 0, b);
                }
            } else {
                TransformerFactory f = TransformerFactory.newInstance();
                Transformer t = f.newTransformer(stylesheet);
                t.setParameter("browseUrl", this.getServletUrl(req) + "?" + PARAM_URL + "=");
                t.setParameter("auxRoot", this.getAuxRoot(req, this.fAuxRoot));
                t.setParameter("browseOverrideStylesheet", "&overrideStylesheet=");
                resp.setContentType("text/html");
                out = new BufferedOutputStream((OutputStream)resp.getOutputStream(), 65536);
                StreamSource s = new StreamSource(in);
                StreamResult r = new StreamResult(out);
                t.transform(s, r);
            }
            try {
                ((OutputStream)out).flush();
                ((OutputStream)out).close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                ((InputStream)in).close();
            }
            catch (Exception e) {}
        }
        catch (Exception e) {
            this.printError(req, resp, e.getMessage(), e);
            return;
        }
    }

    private void addStylesheet(String contentType, Source source, boolean override) {
        if (contentType == null || source == null) {
            return;
        }
        if (override) {
            this.fOverrideStyleSheets.put(contentType.trim().toLowerCase(), source);
        } else {
            this.fStyleSheets.put(contentType.trim().toLowerCase(), source);
        }
    }

    private Source getStylesheet(String contentType, String overrideStylesheet) {
        if (contentType == null) {
            return null;
        }
        Source source = null;
        if (overrideStylesheet != null && overrideStylesheet.length() > 0) {
            source = this.fOverrideStyleSheets.get(overrideStylesheet);
        }
        if (source == null) {
            String[] ctp = contentType.trim().toLowerCase().split(";");
            StringBuilder match = new StringBuilder();
            for (int i = 0; source == null && i < ctp.length; ++i) {
                if (i > 0) {
                    match.append(";");
                }
                match.append(ctp[i]);
                source = this.fStyleSheets.get(match.toString());
            }
        }
        return source;
    }

    private String getContextUrl(HttpServletRequest request) {
        String scheme = request.getScheme();
        int port = request.getServerPort();
        if ("http".equals(scheme) && port == 80) {
            port = -1;
        }
        if ("https".equals(scheme) && port == 443) {
            port = -1;
        }
        return scheme + "://" + request.getServerName() + (port > 0 ? ":" + port : "") + request.getContextPath();
    }

    private String getServletUrl(HttpServletRequest request) {
        return this.getContextUrl(request) + request.getServletPath();
    }

    private String getAuxRoot(HttpServletRequest request, String auxRoot) {
        if (auxRoot == null) {
            return this.getContextUrl(request);
        }
        if (auxRoot.startsWith(CONTEXT_PREFIX)) {
            return this.getContextUrl(request) + auxRoot.substring(CONTEXT_PREFIX.length());
        }
        return auxRoot;
    }

    private void printHeader(PrintWriter pw, String title) {
        pw.print("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"");
        pw.println("\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        pw.println("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
        pw.println("<head>");
        pw.println("<title>" + title + "</title>");
        pw.println("<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\" />");
        pw.println("<style type=\"text/css\">");
        pw.println("body { font-family: arial,sans-serif; font-size: 10pt; }");
        pw.println("div.box { background-color: #f6f1de; margin-top: 10px; margin-bottom: 10px; margin-left: 0px; margin-right: 0px; padding: 5px; border-style: solid; border-width: 1px; border-color: #888a85; }");
        pw.println("</style>");
        pw.println("</head>");
        pw.println("<body>");
    }

    private void printFooter(PrintWriter pw) {
        pw.println("</body>");
        pw.println("</html>");
    }

    private void printError(HttpServletRequest req, HttpServletResponse resp, String message, Exception e) throws IOException {
        resp.setContentType("text/html;charset=utf-8");
        PrintWriter pw = resp.getWriter();
        this.printHeader(pw, "Error");
        pw.println("<div class=\"box\">");
        pw.println("<h3>" + message + "</h3>");
        if (e != null) {
            pw.print("<pre>");
            e.printStackTrace(pw);
            pw.println("</pre>");
        }
        pw.println("</div>");
        this.printFooter(pw);
    }

    private void printInput(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/html;charset=utf-8");
        PrintWriter pw = resp.getWriter();
        this.printHeader(pw, "OpenCMIS Browser");
        pw.println("<img src=\"" + this.getAuxRoot(req, this.fAuxRoot) + "cmis.png\" " + "style=\"float: right;\" />");
        pw.println("<h1 style=\"font-family: Georgia;\">OpenCMIS Browser</h1>");
        pw.println("<div class=\"box\">");
        pw.println("<form action=\"\" method=\"GET\">");
        pw.println("CMIS AtomPub URL: ");
        pw.println("<input name=\"url\" type=\"text\" size=\"100\" value=\"\"/>");
        pw.println("<input type=\"submit\" value=\" GO \"/>");
        pw.println("</form>");
        pw.println("</div>");
        this.printFooter(pw);
    }
}

