/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.spring.authentication;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.fediz.core.ClaimCollection;
import org.apache.cxf.fediz.core.FedizPrincipal;
import org.apache.cxf.fediz.core.processor.FedizResponse;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.w3c.dom.Element;

public class FederationAuthenticationToken
extends AbstractAuthenticationToken
implements Serializable,
FedizPrincipal {
    private static final long serialVersionUID = 320L;
    private final Object credentials;
    private final Object principal;
    private final UserDetails userDetails;
    private final FedizResponse response;
    private List<String> roles = Collections.emptyList();

    public FederationAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities, UserDetails userDetails, FedizResponse response) {
        super(authorities);
        if (principal == null || "".equals(principal) || credentials == null || "".equals(credentials) || authorities == null || userDetails == null || response == null) {
            throw new IllegalArgumentException("Cannot pass null or empty values to constructor");
        }
        this.principal = principal;
        this.credentials = credentials;
        this.userDetails = userDetails;
        this.response = response;
        this.setAuthenticated(true);
        if (response.getRoles() != null) {
            this.roles = response.getRoles();
        }
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public FedizResponse getResponse() {
        return this.response;
    }

    public UserDetails getUserDetails() {
        return this.userDetails;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" Response: ").append(this.response);
        sb.append(" Credentials: ").append(this.credentials);
        return sb.toString();
    }

    public ClaimCollection getClaims() {
        return new ClaimCollection((Collection)this.response.getClaims());
    }

    public Element getLoginToken() {
        return this.response.getToken();
    }

    public List<String> getRoleClaims() {
        return Collections.unmodifiableList(this.roles);
    }
}

